
# server; handles ncon clients at given port
dsmsrvr <- function(port,ncon) {
   cons <- vector(mode="list",length=ncon)
   # make connections with the clients
   for (i in 1:ncon) {
      cons[[i]] <- socketConnection(port=port,server=T,blocking=T)
      readLines(cons[[i]],1)  # read check-in message
      # send the client its ID number, and the group size
      serialize(c(i,ncon),cons[[i]])
   }
   dsmsrvrglbls <<- list()  # globals
   # main loop
   repeat {
      # any service requests?
      rdy <- which(socketSelect(cons))
      if (length(rdy) > 0) {
         con <- cons[[rdy[1]]]  # randomize or something later
         # read client request
         req <- unserialize(con)
         if (req$req == "new") dsmsrvrnew(req) else 
         if (req$req == "vector get") dsmsrvrget(req,con)
      }
   }
}

dsmsrvrnew <- function(rq) {
   rq$req <- NULL
   dsmsrvrglbls[[rq$varname]] <- rq
}

