
//  *****************************************************************  //
//
//  pthsim:  discrete-event simulator, based on the GNU pth threads package 
//
//  *****************************************************************  //

#include <PSimDefs.h>
#include <PSimExterns.h>
#include <stdlib.h>
#include <stdio.h>
#include <pth.h>
#include <math.h>

PTHSAppThread::PTHSAppThread(void * (*FtnPtr) (void *), void *ArgPtr)

{  pth_mutex_init(&this->PTHSThreadMutex);
   pth_cond_init(&this->PTHSThreadCond);
   this->PTHSThreadID = pth_spawn(PTH_ATTR_DEFAULT,*FtnPtr,ArgPtr);
}
      
void PTHSAppThread::PTHSSignalAppThread()

{
   pth_mutex_acquire(&this->PTHSThreadMutex,FALSE,NULL);
   pth_cond_notify(&this->PTHSThreadCond,FALSE);
   pth_mutex_release(&this->PTHSThreadMutex);
   pth_yield(NULL);
}
      
void PTHSAppThread::PTHSWaitAppThread()

{  pth_mutex_acquire(&this->PTHSThreadMutex,FALSE,NULL);
   pth_cond_await(&this->PTHSThreadCond,&this->PTHSThreadMutex,NULL);
   pth_mutex_release(&this->PTHSThreadMutex);
}

PTHSJob::PTHSJob()

{  pth_mutex_init(&this->PTHSEvntMutex);
   pth_cond_init(&this->PTHSEvntCond);
   this->PTHSEvntNext = 0;
}

void PTHSJob::PTHSInsertInEvntLst() 

{  class PTHSJob *Tmp;

   if (PTHSEv->PTHSEvntHead == 0)  {
      PTHSEv->PTHSEvntHead = this;
      this->PTHSEvntNext = 0;
      goto finish;
   }

   if (this->PTHSEvntTime < PTHSEv->PTHSEvntHead->PTHSEvntTime)  {
      this->PTHSEvntNext = PTHSEv->PTHSEvntHead;
      PTHSEv->PTHSEvntHead = this; 
      goto finish;
   }

   Tmp = PTHSEv->PTHSEvntHead; 
   while (1) {
      if (Tmp->PTHSEvntNext == 0)  {
	 Tmp->PTHSEvntNext = this; 
         this->PTHSEvntNext = 0;
	 break;
      }
      else if (this->PTHSEvntTime < Tmp->PTHSEvntNext->PTHSEvntTime)  {
	  this->PTHSEvntNext = Tmp->PTHSEvntNext;
	  Tmp->PTHSEvntNext = this;
	  break;
      }
      Tmp = Tmp->PTHSEvntNext;
   }

   finish: ;

}   

void * PTHSEvntThread(void *)

{  static class PTHSJob *Tmp; 

   while (1)  {
      // need to make sure this thread doesn't start before the
      //    application threads have gotten started, as indicated by an
      //    empty event list
      while (PTHSEv->PTHSEvntHead == 0)  pth_yield(NULL);
      // don't advance simulated time until all application threads, 
      //    of which there are PTHSNAT in number, are waiting 
      while (pth_ctrl(PTH_CTRL_GETTHREADS_WAITING) < PTHSNAT+1) 
             pth_yield(NULL);
      // the rest of this _while_ loop processes one event
      if (PTHSDebug) PTHSEv->PTHSPrintEvntList();
      // get next event and update time
      PTHSEv->PTHSGetNextEvnt();
      PTHSSimTime = PTHSEv->PTHSCurrEvnt->PTHSEvntTime; 
      // end of simulation reached?
      if (PTHSSimTime > PTHSEndSm.PTHSMaxSimTime)  {
         PTHSEndSm.PTHSSignalDone();
         break;
      };
      // wake up PTHSHold(), which in turn will wake up the application 
      //    thread which called it
      pth_mutex_acquire(&PTHSEv->PTHSCurrEvnt->PTHSEvntMutex,FALSE,NULL);
      pth_cond_notify(&PTHSEv->PTHSCurrEvnt->PTHSEvntCond,FALSE);
      pth_mutex_release(&PTHSEv->PTHSCurrEvnt->PTHSEvntMutex);
      PTHSEv->PTHSCurrEvnt = 0;
      // finished with processing event, so yield to application threads
      if (!pth_yield(NULL))
         printf("schedule manager tried to yield but no one ready\n");
   }
   if (PTHSDebug) 
      printf("time %f:  event manager thread exiting\n",PTHSSimTime);
}

PTHSAppServerThread::PTHSAppServerThread(void * (*F) (void *), void *ArgPtr) : 
   PTHSAppThread(F,ArgPtr) 

{  this->PTHSNQ = 0;
   this->PTHSSrvrQHd = this->PTHSSrvrQTl = 0;
}

void PTHSAppServerThread::PTHSAppAddToQ(class PTHSJob *JobPtr)

{  JobPtr->PTHSEvntNext = 0;
   if (this->PTHSNQ == 0)  
      this->PTHSSrvrQHd = this->PTHSSrvrQTl = JobPtr;
   else  {
      this->PTHSSrvrQTl->PTHSEvntNext = JobPtr;
      this->PTHSSrvrQTl = JobPtr;
   }
   if (PTHSDebug) this->PTHSPrintQ();
   if ((this->PTHSNQ++) == 0) this->PTHSSignalAppThread();
}

void PTHSAppServerThread::PTHSWaitGetNextInQ()

{  if (this->PTHSNQ == 0) this->PTHSWaitAppThread();
   this->PTHSNQ--;
   this->PTHSCurrJob = this->PTHSSrvrQHd;
   this->PTHSSrvrQHd = this->PTHSSrvrQHd->PTHSEvntNext;
   if (this->PTHSSrvrQHd == 0) this->PTHSSrvrQTl = 0;
}

void PTHSAppServerThread::PTHSPrintQ()

{  class PTHSJob *Tmp;

   Tmp = this->PTHSSrvrQHd;
   printf("\nserver queue:\n");
   while (Tmp != 0)  {
      printf("   job %d, arrival time %f\n",
             Tmp->PTHSJobNum,Tmp->PTHSArrivalTime);
      Tmp = Tmp->PTHSEvntNext;
   }
}

void PTHSInit(int Argc,char **Argv)  

{  PTHSDebug = atoi(Argv[1]);
   sscanf(Argv[2],"%f",&(PTHSEndSm.PTHSMaxSimTime));
   PTHSSimTime = 0.0;
   PTHSThreadDumpPtr = fdopen(1,"w");
   pth_init();
   PTHSEv = new PTHSEvntLst;
}

PTHSEvntLst::PTHSEvntLst() 

{  this->PTHSEvntHead = this->PTHSCurrEvnt = 0;
   this->PTHSEvntThreadID = 
      pth_spawn(PTH_ATTR_DEFAULT,(void * (*) (void *)) PTHSEvntThread,NULL);
}

// pulls next event from list
void PTHSEvntLst::PTHSGetNextEvnt()  

{  class PTHSJob *Tmp;   

   Tmp = this->PTHSEvntHead;
   if (this->PTHSEvntHead->PTHSEvntNext != 0) 
      this->PTHSEvntHead = this->PTHSEvntHead->PTHSEvntNext;  
   else this->PTHSEvntHead = 0;    
   this->PTHSCurrEvnt = Tmp;
}

void PTHSEvntLst::PTHSPrintEvntList()

{  class PTHSJob *Tmp;

   Tmp = this->PTHSEvntHead;
   printf("\nevent queue at time %f:\n", Tmp->PTHSEvntTime);
   while (Tmp != 0)  {
      printf("job %d, %s at %f\n",
         Tmp->PTHSJobNum,Tmp->PTHSEvntName,Tmp->PTHSEvntTime);
      Tmp = Tmp->PTHSEvntNext;
   }
}

PTHSEndSim::PTHSEndSim()

{  pth_mutex_init(&this->PTHSDoneMutex);
   pth_cond_init(&this->PTHSDoneCond);
}

void PTHSEndSim::PTHSWaitDone()

{  pth_mutex_acquire(&this->PTHSDoneMutex,FALSE,NULL);
   pth_cond_await(&this->PTHSDoneCond,&this->PTHSDoneMutex,NULL);
   pth_mutex_release(&this->PTHSDoneMutex);
}

void PTHSEndSim::PTHSSignalDone()

{  pth_mutex_acquire(&this->PTHSDoneMutex,FALSE,NULL);
   pth_cond_notify(&this->PTHSDoneCond,FALSE);
   pth_mutex_release(&this->PTHSDoneMutex);
}

void PTHSJob::PTHSHold()

{  this->PTHSInsertInEvntLst();
   pth_mutex_acquire(&this->PTHSEvntMutex,FALSE,NULL);
   pth_cond_await(&this->PTHSEvntCond,&this->PTHSEvntMutex,NULL);
   pth_mutex_release(&this->PTHSEvntMutex);
}

void PTHSThreadDump()

{  pth_ctrl(PTH_CTRL_DUMPSTATE,PTHSThreadDumpPtr); }    

float PTHSRnd()

{  return ((float) drand48());  }

float PTHSExpon(float Mean)

{  return -Mean * log((double) PTHSRnd());  }

