
//  *****************************************************************  //
//
//  pthsim:  discrete-event simulator, based on the GNU pth threads package 
//
//  *****************************************************************  //

#include <pth.h>

#define PTHS_MAX_NAME 25 

// application thread class:

class PTHSAppThread  {

   public:

      // PTH variables associated with this thread:
      pth_cond_t PTHSThreadCond;
      pth_mutex_t PTHSThreadMutex;
      pth_t PTHSThreadID;

      // constructor function; parameter is the address of the 
      // application-specific function which will serve as a thread:
      PTHSAppThread(void * (*) (void *), void *);

      // signal and wait functions:
      void PTHSSignalAppThread();
      void PTHSWaitAppThread();

};

// class for one job:

class PTHSJob  {

   public:

      // name of pending/current event for this job:
      char PTHSEvntName[PTHS_MAX_NAME];  
      int PTHSJobNum;  // job number, if any
      float PTHSArrivalTime;  // arrival time, if any
      float PTHSEvntTime;  // event occurence time
      // this is signaled when PTHSHold() finishes, to reactivate the
      // job:
      pth_cond_t PTHSEvntCond;  
      pth_mutex_t PTHSEvntMutex;  // mutex associated with the signal
      class PTHSJob *PTHSEvntNext;  // pointer to next event 

      PTHSJob();  // constructor
      // inserts this job into the event list:
      void PTHSInsertInEvntLst();
      // called to suspend this thread until the event occurs:
      void PTHSHold();

}; 

// server, say for a machine queue:

class PTHSAppServerThread: public PTHSAppThread  {

   public:

      int PTHSNQ;  // queue length
      class PTHSJob *PTHSSrvrQHd,*PTHSSrvrQTl;  // queue head, tail
      class PTHSJob *PTHSCurrJob;  // job currently being served

      // constructor:
      PTHSAppServerThread(void * (*) (void *), void *);  
      // adds the given job to our queue (and wakes server if the queue
      // had been empty):
      void PTHSAppAddToQ(class PTHSJob *);
      // if server has no work to do, this waits until work is
      // available:
      void PTHSWaitGetNextInQ();
      // for debugging:
      void PTHSPrintQ();

};

// this class manages the event list:

class PTHSEvntLst  {

   public:

      class PTHSJob *PTHSEvntHead;  // head of list
      class PTHSJob *PTHSCurrEvnt;  // event currently occurring
      pth_t PTHSEvntThreadID;  // for PTH identification

      PTHSEvntLst();  // constructor
      void PTHSGetNextEvnt();  // moves list head to current event
      void PTHSPrintEvntList();  // for debugging

};

// mechanisms used to end the simulation when the time limit has been
// reached:

class PTHSEndSim  {

   public:

      float PTHSMaxSimTime;  // limit for simulated time
      pth_mutex_t PTHSDoneMutex; 
      pth_cond_t PTHSDoneCond; 

      PTHSEndSim();
      void PTHSWaitDone();
      void PTHSSignalDone();
};

