
//  *****************************************************************  //
//  PSim:  discrete-event simulator, based on user-level threads 
//  *****************************************************************  //

//  M/M/1 queue; jobs arrive and are served at a machine 

#include <string>
#include <cstdlib>

#include <PSimGlobals.h>

float MeanArrive,  // mean time between arrivals
      MeanServe;  // mean service time

float TotWait;  // total queue wait so far

int NJobs;  // total number of jobs done so far

int NQ;

void *Arrivals(void *);
void *Machine(void *);

PTHSAppThread *ArrivalsThread;

PTHSAppServerThread *MachineThread;

void *Arrivals(void *X)

{  int Job=0;
   float FT=0.0;
   PTHSJob *NewArrival;

   for (Job = 0; ; Job++)  { 
      NewArrival = new PTHSJob;
      FT = PTHSSimTime + PTHSExpon(MeanArrive);
      strcpy(NewArrival->PTHSEvntName,"arrival");
      NewArrival->PTHSJobNum = Job;
      NewArrival->PTHSArrivalTime = FT;
      NewArrival->PTHSEvntTime = FT;
      NewArrival->PTHSHold();
      NJobs++;
      MachineThread->PTHSAppAddToQ(NewArrival);
   }
}

void *Machine(void *X)

{  float Tmp,FT; 
   int OldNQ,Jobs;

   for (Jobs = 0; ; Jobs++)  { 
      MachineThread->PTHSWaitGetNextInQ();
      FT = PTHSSimTime + PTHSExpon(MeanServe);
      strcpy(MachineThread->PTHSCurrJob->PTHSEvntName,"service");
      MachineThread->PTHSCurrJob->PTHSEvntTime = FT;
      TotWait += FT - MachineThread->PTHSCurrJob->PTHSArrivalTime;
      MachineThread->PTHSCurrJob->PTHSHold();
   }

}

void OurInit(int Argc, char **Argv)

{  sscanf(Argv[3],"%f",&MeanArrive);
   sscanf(Argv[4],"%f",&MeanServe);
   TotWait = 0.0;
   NQ = 0;
   PTHSNAT = 2;
   ArrivalsThread = new PTHSAppThread(&Arrivals,NULL);
   MachineThread = new PTHSAppServerThread(&Machine,NULL);
}

int main(int argc, char **argv)

{  PTHSInit(argc,argv);  
   OurInit(argc,argv);
   PTHSEndSm.PTHSWaitDone();
   printf("mean queue wait for %d jobs = %f\n",NJobs,TotWait/NJobs);
   exit(1);
}

