

// one simulation facility, e.g. a machine; allows for multiple servers 
// with a common queue 

public class JSFacil  {

   String JSName;  // name of facility, e.g. "machine"
   int JSNServers;  // number of servers (typically 1)
   int JSNBusy;  // number of currently busy servers
   int JSNQ;  // number of jobs in queue
   JSElt JSFclQHd,JSFclQTl;  // ptrs to queue head and tail 

   // appends current event to the queue at "this" facility
   void JSAppendToFclQ() 

   {  if (JSFclQHd == null)  {
         JSFclQHd = JSFclQTl = JSSim.JSCurrEvnt;
         JSSim.JSCurrEvnt.JSNext = null;  
      }
      else  {
         JSFclQTl.JSNext = JSSim.JSCurrEvnt; 
         JSSim.JSCurrEvnt.JSNext = null;
         JSFclQTl = JSSim.JSCurrEvnt; 
      }
      JSNQ++;
   }

   // if the given facility is not busy (must not be called otherwise),
   // this takes the JSElt pointed to by Ptr and starts its service;
   // the argument SrvTm is the service time

   void JSStartServe(JSElt Ptr, float SrvTm)

   {  JSNBusy++;
      Ptr.JSEvntTime = JSSim.JSSimTime + SrvTm;
      Ptr.JSNext = null;
      Ptr.JSInsertInSchedList();
   }

   // does bookkeeping associated with finishing a job, and starting the
   // next job, if any; in the latter case, returns true, but note that the
   // application still must schedule the service, including setting the
   // event time

   boolean JSDoneServe(float SrvTm)  

   {  JSElt OldFclQHd;   

      JSNBusy--;
      if (JSNQ == 0) return false;
   
      OldFclQHd = JSFclQHd;
      if (JSFclQHd == JSFclQTl) JSFclQHd = JSFclQTl = null;
      else JSFclQHd = JSFclQHd.JSNext;
      JSNQ--;

      JSStartServe(OldFclQHd,SrvTm);
      return true;
   }


   void JSPrintFclInfo()

   {  JSElt TmpPtr;
   
      if (JSNBusy > 0)  {
         if (JSNBusy == 1) 
            System.out.println(JSName+" has "+JSNBusy+" job in service, ");
         else
            System.out.println(JSName+" has "+JSNBusy+" jobs in service, ");
         if (JSNQ == 0)  System.out.println("and none ");
         else  {
            System.out.println("and ID(s) ");
            TmpPtr = JSFclQHd;
            while (TmpPtr != null)  {
               System.out.println(TmpPtr.JSEltNumber+" ");
               TmpPtr = TmpPtr.JSNext;
            }
         }
         System.out.println("queued");
      }
      else System.out.println(JSName+" is idle");
   }    


}

