

// JSim sample program:  M/M/1 queue

public class Main // required

{  static int TotJobs = 0;  // number of jobs done so far
   static float TotWait = (float) 0.0;  // total wait for those jobs
   static float MeanArrive,  // mean time between arrivals
                MeanServe;  // mean service time

   public static JSFacil Machine;  

   public static void main(String[] Argv) 

   {  float Tmp;

      JSSim.JSInit(Argv);

      MeanArrive = Float.parseFloat(Argv[2]);
      MeanServe = Float.parseFloat(Argv[3]);

      Machine = new JSFacil();
      Machine.JSName = "machine";
      Machine.JSNServers = 1;

      // set up first arrival
      Tmp = JSSim.JSExpon(MeanArrive);
      JobElt TmpEltPtr = new JobElt();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInSchedList();  

      JSSim.JSMainLoop(Argv);
   
      System.out.println("mean wait = "+TotWait/TotJobs); 
   }

   // event handler:  case "arrive"
   public static void DoArrival()

   {  float Tmp;

      JSSim.JSCurrEvnt.JSName = "done with service";
      // try to serve, else add to machine queue
      if (Machine.JSNBusy == 0)  {
         Tmp = JSSim.JSExpon(MeanServe);
         Machine.JSStartServe(JSSim.JSCurrEvnt,Tmp);
      }
      else Machine.JSAppendToFclQ();
      // schedule the next arrival
      Tmp = JSSim.JSExpon(MeanArrive); 
      Tmp += JSSim.JSSimTime;
      JobElt TmpEltPtr = new JobElt();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInSchedList();
   }

   // event handler:  case "done with service"
   public static void DoDone() 

   {  // process the job which just finished 
      TotJobs++;
      JobElt TmpAE = (JobElt) JSSim.JSCurrEvnt;
      TotWait += JSSim.JSSimTime - TmpAE.ArrivalTime;
      // bookkeeping, plus a check of machine's queue
      float TmpF = JSSim.JSExpon(MeanServe);  
      Machine.JSDoneServe(TmpF);
      return;
   }

   public static void EvntHandler() 

   {  if (JSSim.JSCurrEvnt.JSEvntMatch("arrive")) 
         DoArrival();
      else 
         DoDone();
   }

}


