


// this class contains data and methods related to the general operation
// of JSim

public class JSSim  

{  
   static float JSSimTime;  // current simulated time
   static float JSMaxSimTime;  // amount of simulated time to be run 
   static int JSDebug;  // 1 for debugging, else 0
   public static JSElt JSSchedListHd;
   static JSElt JSCurrEvnt;  // event currently being processed
   static int JSNextNew;  // ID number to be assigned to the next 
                          // JSElt created

   // does the JSim system (i.e. non-application specific) initializations
   static void JSInit(String[] Argv)

   {  JSSchedListHd = null;
      JSCurrEvnt = null;
      JSSimTime = (float) 0.0;
      JSNextNew = 0;
      JSMaxSimTime = Float.parseFloat(Argv[0]);
      JSDebug = Integer.parseInt(Argv[1]);
   }

   // forms the main loop in main() in application program
   static void JSMainLoop(String[] Argv)

   {  while (JSSimTime <= JSMaxSimTime)  {
         JSElt.JSGetNext();
         JSSimTime = JSCurrEvnt.JSEvntTime;
         if (JSDebug == 1)  {
            System.out.println();
            System.out.println();
            System.out.println("***************************************");
            System.out.println();
            System.out.println("time "+JSSimTime);
            System.out.println("current event:");
            JSCurrEvnt.JSPrintElt();
            System.out.println("event list before handling current event:");
            JSPrintSchedList(); 
            System.out.println();
         }
         // wipe out old stuff, to avoid debugging confusion later
         JSCurrEvnt.JSEvntTime = (float) -1.0;   
         JSCurrEvnt.JSNext = null;   
         Main.EvntHandler();  
         if (JSDebug == 1)  {
            System.out.println("event list after handling current event:");
            JSPrintSchedList(); 
            System.out.println();
         }
      }
   }

   // prints out the entire event list
   public static void JSPrintSchedList()

   {  JSElt TmpEltPtr = JSSchedListHd;

      while (TmpEltPtr != null)  {
         TmpEltPtr.JSPrintElt();
         TmpEltPtr = TmpEltPtr.JSNext;   
      }
   
   }

   // U(0,1) random variable generator
   static float JSRnd()

   {  return (float) Math.random(); }

   // exponential random variable generator
   static float JSExpon(float Mu)

   {  return (-Mu*(float) Math.log((double) JSRnd())); }

}


