

// JSim sample program:  M/M/1 queue

public class MM1 extends JSSim  // required

{  static int TotJobs = 0;  // number of jobs done so far
   static float TotWait = (float) 0.0;  // total wait for those jobs
   static float MeanArrive,  // mean time between arrivals
                MeanServe;  // mean service time

   public static JSFacil Machine;  

   public static void main(String[] Argv) 

   {  float Tmp;

      // in JSim's present configuration, this will be required (but
      // will change in the future)
      MM1 Sim = new MM1();

      Sim.JSInit(Argv);

      MeanArrive = Float.parseFloat(Argv[2]);
      MeanServe = Float.parseFloat(Argv[3]);

      Machine = new JSFacil();
      Machine.JSName = "machine";
      Machine.JSNServers = 1;

      // set up first arrival
      Tmp = Sim.JSExpon(MeanArrive);
      ArrivalElt TmpEltPtr = new ArrivalElt();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInSchedList();  

      Sim.JSMainLoop(Argv);
   
      System.out.println("mean wait = "+TotWait/TotJobs); 
   }

   // event handler:  case "will arrive"
   public void DoArrival()

   {  float Tmp;

      JSElt.JSCurrEvnt.JSName = "will be done with service";
      // try to serve, else add to machine queue
      if (Machine.JSNBusy == 0)  {
         Tmp = JSExpon(MeanServe);
         Machine.JSStartServe(JSElt.JSCurrEvnt,Tmp);
      }
      else Machine.JSAppendToFclQ();
      // schedule the next arrival
      Tmp = JSExpon(MeanArrive); 
      Tmp += JSSimTime;
      ArrivalElt TmpEltPtr = new ArrivalElt();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInSchedList();
   }

   // event handler:  case "will be done with service"
   public void DoDone() 

   {  // process the job which just finished 
      TotJobs++;
      ArrivalElt TmpAE = (ArrivalElt) ArrivalElt.JSCurrEvnt;
      TotWait += JSSimTime - TmpAE.ArrivalTime;
      // bookkeeping, plus a check of machine's queue
      float TmpF = JSExpon(MeanServe);  
      Machine.JSDoneServe(TmpF);
      return;
   }

   public void JSEvntHandler() 

   {  if (JSElt.JSCurrEvnt.JSEvntMatch("will arrive")) DoArrival();
      else DoDone();
   }

}


