
// definitions of the member functions of the classes in ESimDefs.h, plus
// declarations of the static variables

#include <ESimDefs.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

// the static variables; see ESimDefs.h for meanings
ESElt *ESElt::ESSchedListHd;
ESElt *ESElt::ESCurrEvnt;
float ESSim::ESSimTime;
float ESSim::ESMaxSimTime;
int ESSim::ESNextNew;
int ESSim::ESDebug;

// here are the member functions; see ESimDefs.h for meanings
ESElt::ESElt()
{  ESEltNumber = ESSim::ESNextNew++;
}

void ESElt::ESInsertInSchedList() 
{  ESElt *Tmp;
        if (ESElt::ESSchedListHd == 0)  {
                ESElt::ESSchedListHd = this;
                return;
        }
        if (ESEvntTime < ESElt::ESSchedListHd->ESEvntTime)  {
                ESNext = ESElt::ESSchedListHd;
                ESElt::ESSchedListHd = this;
                return;
        }
        Tmp = ESElt::ESSchedListHd;
        while (1) {
                if (Tmp->ESNext == 0)  {
                        Tmp->ESNext = this;
                        break;
                }
                else if (ESEvntTime < Tmp->ESNext->ESEvntTime)  {
                        ESNext = Tmp->ESNext;
                        Tmp->ESNext = this;
                        break;
                }
                Tmp = Tmp->ESNext;
        }
}

// removes the head of the schedule list
void ESElt::ESGetNext()
{  ESElt *OldSchedListHd;   
        OldSchedListHd  = ESElt::ESSchedListHd;
        if (ESElt::ESSchedListHd->ESNext == 0) 
                ESElt::ESSchedListHd = 0;
        else ESElt::ESSchedListHd = ESElt::ESSchedListHd->ESNext;
        ESElt::ESCurrEvnt = OldSchedListHd;  
}

// removes the earliest element in the event list having ESEltNum value
// EN, and returns a pointer to the deleted element (or 0, if not found)
ESElt *ESElt::ESCancel(int EN)
{  ESElt *ReturnEltPtr,*TmpEltPtr = ESElt::ESSchedListHd;
        if (TmpEltPtr == 0) return 0;
        if (TmpEltPtr->ESEltNumber == EN)  {
                ESElt::ESSchedListHd = TmpEltPtr->ESNext;
                return TmpEltPtr;
        }
        while (TmpEltPtr->ESNext)  {
                if (TmpEltPtr->ESNext->ESEltNumber == EN)  {
                        ReturnEltPtr = TmpEltPtr->ESNext;
                        TmpEltPtr->ESNext = TmpEltPtr->ESNext->ESNext;
                        return ReturnEltPtr;
                }
                TmpEltPtr = TmpEltPtr->ESNext;   
        }
} 

// does the event type of this ESElt instance match S? (1 means yes)
int ESElt::ESEvntMatch(char *S)
{  return (!strcmp(ESElt::ESCurrEvnt->ESName,S)); }

// ESFacil constructor
ESFacil::ESFacil(const char Nm[], const int NSrvs)
{  strcpy(ESName,Nm); ESNServers = NSrvs; }

// appends this job to the queue at "this" facility
void ESFacil::ESAppendToFclQ() 
{  if (ESFclQHd == 0)  {
        ESFclQHd = ESFclQTl = ESElt::ESCurrEvnt;
        ESElt::ESCurrEvnt->ESNext = 0;  
                       }
else  {
        ESFclQTl->ESNext = ESElt::ESCurrEvnt; 
        ESElt::ESCurrEvnt->ESNext = 0;
        ESFclQTl = ESElt::ESCurrEvnt; 
}
ESNQ++;
}

// if the given facility is not busy (must not be called otherwise),
// this takes the ESElt pointed to by Ptr and starts its service;
// the argument SrvTm is the service time
void ESFacil::ESStartServe(ESElt *Ptr, float SrvTm)
{  ESNBusy++;
        Ptr->ESEvntTime = ESSim::ESSimTime + SrvTm;
        Ptr->ESNext = 0;
        Ptr->ESInsertInSchedList();
}

// does bookkeeping associated with finishing a job, and starting
// the next job, if any; 
// in the latter case, returns 1 (else 0), but note that the application
// still must schedule the service, including setting the event time
int ESFacil::ESDoneServe(float SrvTm)  
{  ESElt *OldFclQHd;   
        ESNBusy--;
        if (ESNQ == 0) return 0;
        OldFclQHd = ESFclQHd;
        if (ESFclQHd == ESFclQTl) ESFclQHd = ESFclQTl = 0;
        else ESFclQHd = ESFclQHd->ESNext;
        ESNQ--;
        ESStartServe(OldFclQHd,SrvTm);
        return 1;
}

void ESFacil::ESPrintFclInfo()
{  ESElt *TmpPtr;
        if (ESNBusy > 0)  {
                if (ESNBusy == 1) 
                        printf("%s has %d job in service, ",ESName,ESNBusy);
                else
                        printf("%s has %d jobs in service, ",ESName,ESNBusy);
                if (ESNQ == 0)  printf("and none ");
                else  {
                        printf("and ID(s) ");
                        TmpPtr = ESFclQHd;
                        while (TmpPtr)  {
                                printf("%d ",TmpPtr->ESEltNumber);
                                TmpPtr = TmpPtr->ESNext;
                        }
                }
                printf("queued\n");
        }
        else printf("%s is idle\n",ESName);
} 

// does the ESim system (i.e. non-application specific) initializations
void ESSim::ESInit(char **Argv)
{  ESElt::ESSchedListHd = 0;
        ESElt::ESCurrEvnt = 0;
        ESSim::ESSimTime = 0.0;
        ESSim::ESNextNew = 0;
        sscanf(Argv[1],"%f",&ESSim::ESMaxSimTime);
        ESSim::ESDebug = atoi(Argv[2]);
}

void ESElt::ESPrintElt()
{  printf("ESElt %d:  %s at %f\n",this->ESEltNumber,
                this->ESName,this->ESEvntTime);
}

void ESElt::ESPrintSchedList()
{  ESElt *TmpEltPtr = ESElt::ESSchedListHd;
        while (TmpEltPtr)  {
                TmpEltPtr->ESPrintElt();
                TmpEltPtr = TmpEltPtr->ESNext;   
        }
}

// forms the main loop in main() in application program, with an outline
// of its action being:
//    while haven't reached simulation time limit yet
//       delete head of event list
//       advance simulated time according to the deleted head
//       call user-written ESEvntHandler(), which will act upon the event
//          according to its event time and other information
void ESSim::ESMainLoop(char **Argv)
{  while (ESSim::ESSimTime <= ESSim::ESMaxSimTime)  {
        ESElt::ESGetNext();
        ESSim::ESSimTime = ESElt::ESCurrEvnt->ESEvntTime;
        if (ESSim::ESDebug)  {
                printf("\n\ntime %f\n",ESSim::ESSimTime);
                printf("current event:\n");
                ESElt::ESCurrEvnt->ESPrintElt();
                printf("event list before handling current event:\n");
                ESElt::ESPrintSchedList(); 
        }
        // wipe out old stuff, to avoid debugging confusion later
        ESElt::ESCurrEvnt->ESEvntTime = -1.0;   
        ESElt::ESCurrEvnt->ESNext = 0;   
        ESElt::ESEvntHandler();  // user-written function, the "case statement" 
        // that handles the various events
        if (ESSim::ESDebug)  {
                printf("event list after handling current event:\n");
                ESElt::ESPrintSchedList(); 
        }
                                                    }
}

float ESSim::ESRnd()
{  return drand48(); }

float ESSim::ESExpon(float Mu)
{  return (-Mu*log((double) ESSim::ESRnd()));  
}


