
// ESim sample program:  M/M/1 queue--1 server, exponential interarrival
// and service times

// usage:  mm1 sim_time_limit debug_flag mean_arrive mean_serve

#include <ESimDefs.h>
#include <stdio.h>
#include <string.h>

class ArrivalElt: public ESElt  {
   public:
      float ArrivalTime;  // time this job arrived
      ArrivalElt();  // constructor
      void ESPrintElt() // override the original version to customize
         {  ESElt::ESPrintElt();  // call the original first
            printf("  arrival was at %f\n",ArrivalTime);
         }
};

// globals
int TotJobsDone = 0;  // number of jobs done so far
float TotWait = 0.0;  // total wait for those jobs

// simulation parameters, from command line
float MeanArrive,  // mean time between arrivals
      MeanServe;  // mean service time

ArrivalElt::ArrivalElt() : ESElt() 
{ strcpy(ESName,"will arrive"); } 

ESFacil Machine("machine",1);

void DoArrival()
{  float Tmp;
   strcpy(ESElt::ESCurrEvnt->ESName,"will be done with service");
   // our new arrival is now pointed to by ESSim::ESCurrEvnt; start
   // service for it if queue is empty, else add to machine queue
   if (Machine.ESNBusy == 0)  {
      Tmp = ESSim::ESExpon(MeanServe);  // generate service time
      Machine.ESStartServe(ESElt::ESCurrEvnt,Tmp);  
   }
   else Machine.ESAppendToFclQ();
   // generate the next arrival
   Tmp = ESSim::ESExpon(MeanArrive); 
   Tmp += ESSim::ESSimTime;
   ArrivalElt *TmpEltPtr = new ArrivalElt();
   TmpEltPtr->ESEvntTime = Tmp;
   TmpEltPtr->ArrivalTime = Tmp;
   TmpEltPtr->ESInsertInSchedList();
}

void DoDone() 
{ // process the job which just finished, which is now pointed to
  // by ESSim::ESCurrEvnt 
   TotJobsDone++;
   TotWait += 
      ESSim::ESSimTime - ( (ArrivalElt *) ESElt::ESCurrEvnt)->ArrivalTime;
   delete ESElt::ESCurrEvnt;
   // bookkeeping, plus a check of machine's queue
   float Tmp = ESSim::ESExpon(MeanServe);  
   Machine.ESDoneServe(Tmp);
   return;
}

// this function is called from within ESim, in the main loop
void ESElt::ESEvntHandler() 
{  if (ESElt::ESEvntMatch("will arrive")) DoArrival();
   else DoDone();
}

int main(int Argc, char **Argv) 
{  float Tmp;
   ESSim::ESInit(Argv);
   sscanf(Argv[3],"%f",&MeanArrive);
   sscanf(Argv[4],"%f",&MeanServe);
   // set up first arrival
   Tmp = ESSim::ESExpon(MeanArrive);
   ArrivalElt *TmpEltPtr = new ArrivalElt();
   TmpEltPtr->ESEvntTime = Tmp;
   TmpEltPtr->ArrivalTime = Tmp;
   strcpy(TmpEltPtr->ESName,"will arrive");
   TmpEltPtr->ESInsertInSchedList();  
   // now start the simulation
   ESSim::ESMainLoop(Argv);
   // print out the results
   printf("mean wait = %f\n",TotWait/TotJobsDone); 
}

