
# each shared scalar in a PerlDSM application program is stored
# internally as one of these, and tied to an ordinary scalar used by the
# application program

# arguments to "tie" are the class name, DSMSharedVarClass, the name of
# the tied variable, and the socket

package DSMScalar;

sub TIESCALAR {
   # get arguments
   my $Class = shift;
   $VarName = shift;
   my $Skt = shift;
   my $R = {VrNm=>$VarName, SvrSkt=>$Skt};
   # notify server about this variable
   print $Skt "create ", $VarName, " 0\n";
   my $Response = <$Skt>;
   # bless the reference to $VarName with the package name
   bless $R, $Class;
   return $R;
}

sub FETCH {
   # get reference to this object from the argument
   my $R = shift;
   my $VarName = $R->{VrNm}; 
   my $Skt = $R->{SvrSkt}; 
   print $Skt "read ", $VarName, " 0\n";
   my $Response = <$Skt>;
   return $Response;
}

sub STORE {
   # get reference to this object from the argument
   my $R = shift;
   my $VarName = $R->{VrNm}; 
   my $Skt = $R->{SvrSkt}; 
   # set the data to the second argument, dereferencing the pointer
   my $D = shift;
   print $Skt "write ", $VarName, " ", $D, "\n";
   my $Response = <$Skt>;
}

1;  # needed due to quirk in Perl

