#include <stdio.h>
#include <string.h>
#include "micstr.h"
/*
   routines to disassemble one microinstruction word
                                                                */
int disassemble(word, statement)
  MICROINSTRUCTION word;
  char statement[];
/*
  given a microinstruction "bitstring", returns the equivalent
  in symbolic assembly language
                                                                 */
{
  char rhs[40], condst[20], initlabel[6];

  *statement = '\0';

  /* load mbr? */
  if(word.mbr != '*')
   if(word.mbr)
    {strcat(statement, "mbr := ");
     out_shift(word,rhs);
     strcat(statement,rhs);
     strcat(statement,"; ");
    }
  /* load mar? */
  if(word.mar != '*')
   if(word.mar)
    {strcat(statement, "mar := ");
     regname((int)word.breg,rhs) ;
     strcat(statement,rhs);
     strcat(statement,"; ");
    }
/*  alu, scratchpad regs */
  if(word.enc != '*')
   {if(word.enc == 0)
     strcat(statement, "alu := ");
    else
     {regname((int)word.creg,rhs) ;
      strcat(statement, rhs);
      strcat(statement, " := ");
     }
    out_shift(word,rhs); 
    strcat(statement, rhs);
    strcat(statement, "; ");
   }
  if(word.rd != '*')
    if((int)word.rd)
      strcat(statement, "rd; ");
  if(word.wr != '*')
    if((int)word.wr)
      strcat(statement, "wr; ");
  if(word.cond != '*')
    if((int)word.cond)
     {switch((int)word.cond)
       {case 1: sprintf(condst,"if n then goto %d;",(int)(0x00ff & word.addr));
                break;
        case 2: sprintf(condst,"if z then goto %d;",(int) (0x0ff & word.addr));
                break;
        case 3: sprintf(condst,"goto %d;",(int) (0x0ff &word.addr));
       }
      strcat(statement,condst);
     }
 return 0;
}
int out_shift(word, rhs)
/*
   given a microinstruction word, figures out what's happening
   with the alu and shifter
                                                                 */
MICROINSTRUCTION word;
char rhs[];
{ char str[30];
  static char *shift[2] = {"rshift( ", "lshift( "};

  rhs[0] = '\0';
  if(word.sh == '*') return -1;
  if((int)word.sh > 0 && (int)word.sh < 3)
    { strcat(rhs,shift[(int)word.sh - 1]);
      out_alu(word,str); 
      strcat(rhs,str);
      strcat(rhs, ")");
      return 0;
    }
  out_alu(word,str);
  strcpy(rhs,str);
  return 0;
}
int out_alu(word,str)
MICROINSTRUCTION word;
char str[];
{
  char s1[10],s2[10];

  *str = '\0';
  out_amux(word,s1); 
  switch((int)word.alu)
   { case 0: { regname((int)word.breg,s2);
               sprintf(str,"%s + %s ",s1,s2);
               return 0;
             }
     case 1: { regname((int)word.breg,s2);
               sprintf(str,"band (%s, %s)",s1,s2);
               return 0;
             }
     case 2: { strcpy(str,s1);
               return 0;
             }
     case 3: { sprintf(str, "inv(%s)", s1);
               return 0;
             }
    default: return -1;
   }
}
int out_amux(word, str)
MICROINSTRUCTION word;
char str[];
{  char s1[10];

   *str = '\0';
   if(word.amux == '*') return -1;
   if((int)word.amux == 0)
     {regname((int)word.areg,s1);
      strcpy(str,s1);
      return 0;
     }
   strcpy(str,"mbr");
   return 0;
}
int regname(regno,name)
/* given the register number, returns a string containing the
   register name
                                                                 */
  int regno;
  char name[];
{
 
 static char *names[16] =
              {"pc",   "ac",   "sp", "ir", "tir", "0", "1", "-1",
               "amask","smask","a",  "b",  "c",   "d", "e", "f"  };
 
 if(regno < 0 || regno > 15) return -1;
 strcpy(name,names[regno]);
 return 0;
}
