
# line 2 "mic.gram"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "mytokens.h"
#include "micstr.h"

int src_lines = 0;		        /* current line of source       */
int label_value;			

/*  the following for error handling */
int unrecchar, 				/* unrecognized character        */
    unrectoken, 			/* unrecognized token            */
    typeline;				/* 1 -- 'mbr =:'                 */
                                        /* 2 -- 'rd'                     */
                                        /* 3 -- 'wr'                     */
                                        /* used for a little semantic
                                           analysis                      */
int foundwr, 				/* 'wr' present in line          */
    foundrd, 				/* 'rd' present in line          */
    foundlabel, 			/* statement label present       */
    foundmbr;                           /* 'mbr' present in line         */
char errstrng[50];			/* offensive token stored here   */
char errch;				/* offensive char stored here    */
					/*    used in printing error msg */
/*  end error handling */

int obj_lines = 0;			/* number of obj lines generated */
extern REF_TABLE refs[256];		/* references in source          */
extern int jref;			/* number of references          */

extern int bomb;			/* =0 -> correct input           */
 
MICROINSTRUCTION instr; 		/*current instruction            */
extern FILE *pobj;  			/* object file                   */
extern FILE *psrc;  			/* source file                   */
extern int yydebug;
# define wrp 300
# define rdp 301
# define ifp 302
# define then 303
# define gotop 304
# define digitstr 305
# define n 306
# define z 307
# define marp 308
# define pc 309
# define ac 310
# define sp 311
# define ir 312
# define tir 313
# define amask 314
# define smask 315
# define const0 316
# define const1 317
# define constm1 318
# define aregp 319
# define bregp 320
# define cregp 321
# define dreg 322
# define ereg 323
# define freg 324
# define mbrp 325
# define rshift 326
# define lshift 327
# define band 328
# define inv 329
# define alup 330
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 269 "mic.gram"

int yylex()
{ int c;
  extern int yyval;

 al:if(!span_white())return EOF;
   c = getc(psrc); /* there's one out there bc it was ungotc in span-wh */
   if(c == '\n') return c;
   if(ispunc(c)) return c;      /* legal punct     */
   if(isbrace(c))               /* ignore comments */
     {if(!span_comment())return EOF;
      goto al;
     }
   if(isletter(c))              /* alpha string    */
     {ungetc(c,psrc);
      return get_token();
     }
   if(isdigit(c))               /* numeric string  */
     {ungetc(c,psrc);
      label_value = makeint();
      if(label_value == 0) return CONST0;
      if(label_value == 1) return CONST1;
      return DIGITSTR;
     }
   if(isminus(c))              /* special '-1 reg  */
     {label_value = -makeint();
      if(label_value == -1) return CONSTM1;
     }
   /*  error */
   unrecchar = 1;
   errch = c;
   return c;
}

int isminus(ch)
int ch;
{
  if((char) ch == '-') return 1;
  return 0;
}

int ispunc(ch)
int ch;
{
  switch((char) ch)
   { case ';':
     case '(':
     case ')':
     case '=':
     case ':':
     case '+':
     case ',': return 1;
     default: return 0;
    }
}

int isbrace(ch)
int ch;
{  if((char) ch == '{') return 1;
   return 0;
}

int isletter(ch)
int ch;
{
  if(0x41 <= ch && ch <= 0x5a) return 1;
  if(0x61 <= ch && ch <= 0x7a) return 1;
  return 0;
}

int span_comment()
/*
  picks off comment, updates source-line count, if necessary
                    						*/
{
  int ch;
  
  while((ch=getc(psrc)) != EOF)
     {if(ch == '}') return 1;
      if(ch == '\n') 
        {++src_lines;
         if(yydebug)
            printf(" starting to process line %d \n", src_lines);
        }
     }
  return 0;
}

int span_white()
/*
  spans white space, updates source-line count, if necessary
                                                             */
{ int ch;
  
  while((ch=getc(psrc)) != EOF)
    if(ch <= 0x20 && ch != 0xa)
      ;
    else
      { if(ch == '\n')
          {++src_lines; 
           if(yydebug)
               printf(" starting to process line %d \n",src_lines);
          }
        ungetc(ch,psrc);
        return 1;
      }
  return 0;
}

int get_token()
{
  char str[50];
  void get_letter();

  get_letter(str);
  if(!strncmp(str,"rshift",6)) return RSHIFT;
  if(!strncmp(str,"lshift",6)) return LSHIFT;
  if(!strncmp(str,"amask",5)) return AMASK;
  if(!strncmp(str,"smask",5)) return SMASK;
  if(!strncmp(str,"band",4)) return BAND;
  if(!strncmp(str,"then",4)) return THEN;
  if(!strncmp(str,"goto",4)) return GOTO;
  if(!strncmp(str,"mar",3)) return MAR;
  if(!strncmp(str,"mbr",3)){foundmbr = 1;
                            return MBR;
                           }
  if(!strncmp(str,"tir",3)) return TIR;
  if(!strncmp(str,"inv",3)) return INV;
  if(!strncmp(str,"alu",3)) return ALU;
  if(!strncmp(str,"pc",2)) return PC;
  if(!strncmp(str,"ac",2)) return AC;
  if(!strncmp(str,"sp",2)) return SP;
  if(!strncmp(str,"ir",2)) return IR;
  if(!strncmp(str,"wr",2)) {foundwr = 1;
                            return WR; 
                           }
  if(!strncmp(str,"rd",2)) {foundrd = 1;
                            return RD;
                           }
  if(!strncmp(str,"if",2)) return IF;
  if(!strncmp(str,"n",1)) return N;
  if(!strncmp(str,"z",1)) return Z;
  if(!strncmp(str,"a",1)) return A;
  if(!strncmp(str,"b",1)) return B;
  if(!strncmp(str,"c",1)) return C;
  if(!strncmp(str,"d",1)) return D;
  if(!strncmp(str,"e",1)) return E;
  if(!strncmp(str,"f",1)) return F;
  /*  error */
  unrectoken = 1;
  strcpy(errstrng,str);
  return OTHER;
}

void get_letter(str)
char str[];
{
  int ch;
  int j;

  j = 0;
  while((ch = getc(psrc)) != EOF && isletter(ch))
    str[j++] = (char) ch;
  str[j] = '\0';
  ungetc(ch,psrc);
}

int makeint()
{
  int sum,j;
  char str[50];
  void get_number();

  get_number(str);
  sum = 0;
  j = 0;
  while(str[j] != '\0')
    sum = sum * 10 + str[j++] - '0';
  return sum;
}

void get_number(str)
char str[];
{
  int j,ch;

  j = 0;
  while(((ch=getc(psrc)) != EOF) && isdigit(ch))
     str[j++] = (char) ch;
  str[j] = '\0';
  ungetc(ch,psrc);
}

int reset_errors()
{
  unrecchar = 0;
  unrectoken = 0;
  typeline = 0;
  foundwr = 0;
  foundrd = 0;
  foundlabel = 0;
  foundmbr = 0;
  errstrng[0] = '\0';
  errch = ' ';
  return 1;
}

errormsg()
{ char msg[50];

  if(!foundlabel)
   {sprintf(msg, "%d:begin line with a label",
             src_lines);
    yyerror(msg); 
    return 1;
   }
  if(unrectoken)
   {sprintf(msg, "%d:unrecognized token -- %s",
             src_lines, errstrng);
    yyerror(msg); 
    return 1;
   }
  if(unrecchar)
   {sprintf(msg,"%d:illegal character -- %c",
             src_lines,errch);
    yyerror(msg); 
    return 1;
   }
  switch(typeline)
   { case 1: {if(foundrd)
                {sprintf(msg, "%d:cannot use 'rd' with 'mbr :='",
                             src_lines);
                 yyerror(msg); 
                 return 1;
                }
              break;
             }
     case 2: {if(foundwr)
                {sprintf(msg, "%d:cannot use 'wr' with 'rd'", 
                             src_lines);
                 yyerror(msg); 
                 return 1;
                }
              if(foundmbr)
                {sprintf(msg, "%d:cannot use 'mrb :=' with 'rd'",
                             src_lines);
                 yyerror(msg); 
                 return 1;
                }
              break;
             }
     case 3: {if(foundrd)
                {sprintf(msg, "%d:cannot 'wr' with 'rd'",
                             src_lines);
                 yyerror(msg); 
                 return 1;
                }
              break;
             }
     default: break;
    }
  sprintf(msg,"%d:syntax error", src_lines);
  yyerror(msg); 
  return 1;
}

yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 19,
	10, 26,
	-2, 15,
-1, 57,
	10, 27,
	-2, 18,
-1, 66,
	10, 28,
	-2, 17,
-1, 78,
	10, 29,
	-2, 19,
	};
# define YYNPROD 76
# define YYLAST 496
yytabelem yyact[]={

    56,     6,    77,    51,    72,    73,   102,    85,    34,     3,
    20,   100,     7,     8,    95,    92,    62,    17,    91,    22,
    88,    87,    61,    84,   120,    83,    59,    15,   114,   113,
    51,   111,   105,    19,    60,    65,    66,    64,    57,    86,
    69,    68,    74,    76,    75,    70,    67,    10,   123,   108,
   126,   124,   122,   121,    89,    51,   110,   109,   107,   106,
    55,    16,    54,    53,    11,    42,     2,    18,     9,    71,
    30,    29,    27,    59,    78,    79,    59,    59,    80,    63,
    64,    82,    51,    58,    26,    81,    25,    14,    13,    59,
    59,    59,    99,   101,    12,     1,    99,    99,    90,     0,
     0,    59,    64,     0,     0,    51,   103,   104,     0,     0,
     0,     0,   112,     0,     0,    99,    99,   101,    99,    99,
   117,     0,   115,   116,   118,   119,     0,    51,     0,     0,
     0,     0,   101,     0,     0,   125,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    51,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,    51,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    51,     0,     4,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    24,    23,    31,     0,    32,     0,     0,
     0,    28,    35,    36,    37,    38,    39,    43,    44,    40,
    41,    52,    45,    46,    47,    48,    49,    50,    21,     0,
    24,    23,    31,    33,    32,     0,     0,     0,    28,    35,
    36,    37,    38,    39,    43,    44,    40,    41,    52,    45,
    46,    47,    48,    49,    50,    24,     0,    31,     0,    32,
    33,     0,     0,    28,    35,    36,    37,    38,    39,    43,
    44,    40,    41,    52,    45,    46,    47,    48,    49,    50,
    21,     0,    24,     0,    31,    33,    32,     0,     0,     0,
    28,    35,    36,    37,    38,    39,    43,    44,    40,    41,
    52,    45,    46,    47,    48,    49,    50,    31,     0,    32,
     0,     0,    33,    28,    35,    36,    37,    38,    39,    43,
    44,    40,    41,    52,    45,    46,    47,    48,    49,    50,
     0,     0,     0,     0,     0,    33,    35,    36,    37,    38,
    39,    43,    44,    40,    41,    52,    45,    46,    47,    48,
    49,    50,    98,    93,    94,    96,    97,    35,    36,    37,
    38,    39,    43,    44,    40,    41,    52,    45,    46,    47,
    48,    49,    50,    98,     5,     0,    96,    97,    35,    36,
    37,    38,    39,    43,    44,    40,    41,    52,    45,    46,
    47,    48,    49,    50,    98,    35,    36,    37,    38,    39,
    43,    44,    40,    41,    52,    45,    46,    47,    48,    49,
    50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     6,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     7,     8 };
yytabelem yypact[]={

   178,   178, -1000,   -11, -1000,    54, -1000, -1000, -1000, -1000,
   -37, -1000,    53,    52,    50,   -10,    42,    15,    65,    65,
 -1000,   -12, -1000,   -18,   -19, -1000, -1000, -1000,   -13, -1000,
 -1000,  -302,  -304,   -14,   -15, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,  -316, -1000, -1000, -1000, -1000, -1000,    65,    65, -1000,
    42,    65,    42,    42, -1000,    65,    65,   -36, -1000, -1000,
   -38,  -296, -1000, -1000,   -20,   -40,   -41,    13,    65,    65,
    65,    65,    42,    87,   146,  -298, -1000,    87,    87, -1000,
    65,   -27, -1000,    19,    18,     6,    17,    16, -1000, -1000,
   -28, -1000,  -304,   -30,   -31, -1000,   108,   108,   146,   129,
   129, -1000,   -35, -1000, -1000,    12,    11, -1000,     4,    10,
 -1000, -1000, -1000,   146, -1000,     9, -1000 };
yytabelem yypgo[]={

     0,    95,    66,     9,    94,    88,    87,    16,    61,    17,
    19,    22,    67,    10,    86,    84,    72,    71,    70,    18,
     8,    69,    11,    15,    14,    65 };
yytabelem yyr1[]={

     0,     1,     1,     2,     2,     2,     2,     2,     2,     4,
     4,     4,     4,     9,     9,    10,    10,    10,    10,    10,
     5,     5,     5,     5,     7,     7,     6,     6,     6,     6,
    13,    13,    13,    11,    12,    15,    15,    17,    18,    16,
    16,    21,    21,    14,     8,    19,    19,    19,    23,    23,
    23,    23,    24,    24,    22,    20,    20,    20,    20,    20,
    20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
    20,    25,    25,     3,     3,     3 };
yytabelem yyr2[]={

     0,     4,     2,     9,     9,     9,     9,     2,     5,     3,
     5,     5,     7,     4,     2,     2,     2,     4,     4,     6,
     3,     5,     5,     7,     5,     3,     3,     5,     5,     7,
     2,     2,     2,     5,     5,     2,     2,    11,    11,    13,
     7,     3,     3,    11,    11,     3,     9,     9,     7,    13,
     3,     9,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     6,     2,     3,     3,     3 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -3,    10,   256,   305,   316,   317,    -2,
    58,    10,    -4,    -5,    -6,    -7,    -8,    -9,   -12,   -11,
   -13,   325,   -10,   301,   300,   -14,   -15,   -16,   308,   -17,
   -18,   302,   304,   330,   -20,   309,   310,   311,   312,   313,
   316,   317,   -25,   314,   315,   319,   320,   321,   322,   323,
   324,    40,   318,    10,    10,    10,    10,   -11,   -12,   -13,
    -9,   -11,    -7,    -8,   -10,    -7,    -7,    58,    59,    59,
    58,   -21,   306,   307,    -3,    58,    58,   318,    -7,    -7,
    -7,   -11,    -9,    61,    61,   303,    59,    61,    61,    41,
    -7,   -19,   -23,   326,   327,   -24,   328,   329,   325,   -20,
   -22,   -20,   304,   -19,   -19,    59,    40,    40,    43,    40,
    40,    59,    -3,    59,    59,   -23,   -23,   -22,   -24,   -24,
    59,    41,    41,    44,    41,   -22,    41 };
yytabelem yydef[]={

     0,    -2,     2,     0,     7,     0,    73,    74,    75,     1,
     0,     8,     0,     0,     0,    16,     9,     0,    20,    -2,
    25,     0,    14,     0,     0,    30,    31,    32,     0,    35,
    36,     0,     0,     0,     0,    55,    56,    57,    58,    59,
    60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
    70,     0,    72,     3,     4,     5,     6,    -2,    21,    24,
    11,    15,    16,    10,    13,    22,    -2,     0,    34,    33,
     0,     0,    41,    42,     0,     0,     0,     0,    -2,    23,
    17,    18,    12,     0,     0,     0,    40,     0,     0,    71,
    19,     0,    45,     0,     0,    50,     0,     0,    52,    53,
     0,    54,     0,     0,     0,    44,     0,     0,     0,     0,
     0,    43,     0,    37,    38,     0,     0,    48,     0,     0,
    39,    46,    47,     0,    51,     0,    49 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"wrp",	300,
	"rdp",	301,
	"ifp",	302,
	"then",	303,
	"gotop",	304,
	"digitstr",	305,
	"n",	306,
	"z",	307,
	"marp",	308,
	"pc",	309,
	"ac",	310,
	"sp",	311,
	"ir",	312,
	"tir",	313,
	"amask",	314,
	"smask",	315,
	"const0",	316,
	"const1",	317,
	"constm1",	318,
	"aregp",	319,
	"bregp",	320,
	"cregp",	321,
	"dreg",	322,
	"ereg",	323,
	"freg",	324,
	"mbrp",	325,
	"rshift",	326,
	"lshift",	327,
	"band",	328,
	"inv",	329,
	"alup",	330,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"prog : prog linet",
	"prog : linet",
	"linet : label ':' line1 '\n'",
	"linet : label ':' line2 '\n'",
	"linet : label ':' line3 '\n'",
	"linet : label ':' macs '\n'",
	"linet : '\n'",
	"linet : error '\n'",
	"line1 : mbreq",
	"line1 : withmbr mbreq",
	"line1 : mbreq withmbr",
	"line1 : withmbr mbreq withmbr",
	"withmbr : withmbr stat1",
	"withmbr : stat1",
	"stat1 : wrcmd",
	"stat1 : macs",
	"stat1 : wrcmd macs",
	"stat1 : macs wrcmd",
	"stat1 : macs wrcmd macs",
	"line2 : rdcmd",
	"line2 : macs rdcmd",
	"line2 : rdcmd macs",
	"line2 : macs rdcmd macs",
	"macs : macs maralcon",
	"macs : maralcon",
	"line3 : wrcmd",
	"line3 : macs wrcmd",
	"line3 : wrcmd macs",
	"line3 : macs wrcmd macs",
	"maralcon : mareq",
	"maralcon : alregeq",
	"maralcon : cond",
	"wrcmd : wrp ';'",
	"rdcmd : rdp ';'",
	"alregeq : alueq",
	"alregeq : regeq",
	"alueq : alup ':' '=' outshift ';'",
	"regeq : scrpad ':' '=' outshift ';'",
	"cond : ifp nzregs then gotop label ';'",
	"cond : gotop label ';'",
	"nzregs : n",
	"nzregs : z",
	"mareq : marp ':' '=' bregs ';'",
	"mbreq : mbrp ':' '=' outshift ';'",
	"outshift : outalu",
	"outshift : rshift '(' outalu ')'",
	"outshift : lshift '(' outalu ')'",
	"outalu : amuxout '+' bregs",
	"outalu : band '(' amuxout ',' bregs ')'",
	"outalu : amuxout",
	"outalu : inv '(' amuxout ')'",
	"amuxout : mbrp",
	"amuxout : scrpad",
	"bregs : scrpad",
	"scrpad : pc",
	"scrpad : ac",
	"scrpad : sp",
	"scrpad : ir",
	"scrpad : tir",
	"scrpad : const0",
	"scrpad : const1",
	"scrpad : regm1",
	"scrpad : amask",
	"scrpad : smask",
	"scrpad : aregp",
	"scrpad : bregp",
	"scrpad : cregp",
	"scrpad : dreg",
	"scrpad : ereg",
	"scrpad : freg",
	"regm1 : '(' constm1 ')'",
	"regm1 : constm1",
	"label : digitstr",
	"label : const0",
	"label : const1",
};
#endif /* YYDEBUG */
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	@(#)yaccpar	1.9	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:
# line 76 "mic.gram"
{put_instr(pobj,instr);
                 ++obj_lines;
           	 init_instr();
           	 reset_errors();
         	} break;
case 4:
# line 82 "mic.gram"
{put_instr(pobj,instr);
                 ++obj_lines;
           	 init_instr();
           	 reset_errors();
         	} break;
case 5:
# line 88 "mic.gram"
{put_instr(pobj,instr);
                 ++obj_lines;
           	 init_instr();
           	 reset_errors();
         	} break;
case 6:
# line 94 "mic.gram"
{put_instr(pobj,instr);
                 ++obj_lines;
           	 init_instr();
           	 reset_errors();
         	} break;
case 8:
# line 101 "mic.gram"
{
                 errormsg();
                 bomb = 1;
           	 reset_errors();
          	} break;
case 9:
# line 108 "mic.gram"
{typeline = 1;} break;
case 10:
# line 110 "mic.gram"
{typeline = 1;} break;
case 11:
# line 112 "mic.gram"
{typeline = 1;} break;
case 12:
# line 114 "mic.gram"
{typeline = 1;} break;
case 20:
# line 126 "mic.gram"
{typeline = 2;} break;
case 21:
# line 128 "mic.gram"
{typeline = 2;} break;
case 22:
# line 130 "mic.gram"
{typeline = 2;} break;
case 23:
# line 132 "mic.gram"
{typeline = 2;} break;
case 24:
# line 135 "mic.gram"
{typeline = 4;} break;
case 25:
# line 137 "mic.gram"
{typeline = 4;} break;
case 26:
# line 140 "mic.gram"
{typeline = 3;} break;
case 27:
# line 142 "mic.gram"
{typeline = 3;} break;
case 28:
# line 144 "mic.gram"
{typeline = 3;} break;
case 29:
# line 146 "mic.gram"
{typeline = 3;} break;
case 33:
# line 153 "mic.gram"
{instr.wr = 1;
            	} break;
case 34:
# line 157 "mic.gram"
{
             	 instr.rd = 1;
            	} break;
case 37:
# line 165 "mic.gram"
{instr.enc = 0;} break;
case 38:
# line 168 "mic.gram"
{instr.enc = 1;
             	instr.creg = yypvt[-4] - 400;
            	} break;
case 39:
# line 173 "mic.gram"
{instr.addr = yypvt[-1];
               	 refs[jref].line = src_lines + 1;
             	 refs[jref].ref = yypvt[-1];
                 ++jref;
            	} break;
case 40:
# line 179 "mic.gram"
{instr.cond = 3;
             	 instr.addr = (char) yypvt[-1];
		 refs[jref].line = src_lines + 1;
 		 refs[jref].ref = yypvt[-1];
		 ++jref;
            	} break;
case 41:
# line 187 "mic.gram"
{instr.cond = 1;} break;
case 42:
# line 189 "mic.gram"
{instr.cond = 2;} break;
case 43:
# line 192 "mic.gram"
{instr.mar = 1;} break;
case 44:
# line 195 "mic.gram"
{instr.mbr = 1;} break;
case 45:
# line 198 "mic.gram"
{instr.sh = 0;} break;
case 46:
# line 200 "mic.gram"
{instr.sh = 1;} break;
case 47:
# line 202 "mic.gram"
{instr.sh = 2;} break;
case 48:
# line 205 "mic.gram"
{instr.alu = 0;} break;
case 49:
# line 207 "mic.gram"
{instr.alu = 1;} break;
case 50:
# line 209 "mic.gram"
{instr.alu = 2;} break;
case 51:
# line 211 "mic.gram"
{instr.alu = 3;} break;
case 52:
# line 214 "mic.gram"
{instr.amux = 1;} break;
case 53:
# line 216 "mic.gram"
{instr.amux = 0;
             instr.areg = yypvt[-0] - 400;} break;
case 54:
# line 220 "mic.gram"
{instr.breg = yypvt[-0] - 400;} break;
case 55:
# line 223 "mic.gram"
{yyval = 400;} break;
case 56:
# line 225 "mic.gram"
{yyval = 401;} break;
case 57:
# line 227 "mic.gram"
{yyval = 402;} break;
case 58:
# line 229 "mic.gram"
{yyval = 403;} break;
case 59:
# line 231 "mic.gram"
{yyval = 404;} break;
case 60:
# line 233 "mic.gram"
{yyval = 405;} break;
case 61:
# line 235 "mic.gram"
{yyval = 406;} break;
case 62:
# line 237 "mic.gram"
{yyval = 407;} break;
case 63:
# line 239 "mic.gram"
{yyval = 408;} break;
case 64:
# line 241 "mic.gram"
{yyval = 409;} break;
case 65:
# line 243 "mic.gram"
{yyval = 410;} break;
case 66:
# line 245 "mic.gram"
{yyval = 411;} break;
case 67:
# line 247 "mic.gram"
{yyval = 412;} break;
case 68:
# line 249 "mic.gram"
{yyval = 413;} break;
case 69:
# line 251 "mic.gram"
{yyval = 414;} break;
case 70:
# line 253 "mic.gram"
{yyval = 415;} break;
case 73:
# line 259 "mic.gram"
{yyval = label_value;
             	 foundlabel = 1;
            	} break;
case 74:
# line 263 "mic.gram"
{yyval == label_value;
             	 foundlabel = 1;} break;
case 75:
# line 266 "mic.gram"
{yyval = label_value;
             	 foundlabel = 1;} break;
	}
	goto yystack;		/* reset registers in driver code */
}
