/*
   function to renumber mal programs.  User may use any
   combination of letters, numbers, and punction as
   new labels as long as:
          new labels do not contain colons or semicolons
          new labels do not contain the substring "goto"
   If the program finds that it can successfully renumber
   the source, it overwrites the original source with
   the updated source.
                                            rjn 26 june 91  */
#include <stdio.h>
#include <string.h>
char mal[1000][81];    /* holds text of source code          */
char *srclabel[1000];  /* just the labels of the source code */
char *newlabel[1000];  /* new lables                         */
/*************************************************************/
int renum(name)
/*************************************************************/
 char name[];          /* (w/o dot extention)                */
{
  char fullname[256];
  FILE *ifp;
  int  linecount;

  strcpy(fullname,name);
  strcat(fullname,".mal"); 
  if((ifp = fopen(fullname,"r")) == (FILE *) NULL)
    { if((ifp = fopen(name, "r")) == (FILE *) NULL)
         {fprintf(stderr, "couldn't open %s as input\n", name);
          return 1;
         }
      else
          strcpy(fullname,name);
    }
  if(!readsrc(ifp,&linecount))     /* read in source and record old labels*/
     return 0;
  makelineno(linecount);                               /* make new labels */
  if(!wrfilenswap(fullname,ifp,linecount))  /* write out relabeled source */
     return 0;
  return 1;
}
/**************************************************************************/
readsrc(ifp,count)
/**************************************************************************/
/* read in source file.  A label is defined to be anything that occurs
   before the initial colon.  The labels are stripped from the remainder
   of the line and placed in array srclabel.  There is one entry in srclabel
   for every source line.  If a source line is blank or a comment, its
   corresponding entry in srclabel is set to null, and the entire
   line is stored in the mal array.  (for lines with labels, only
   that part occuring after the label is stored in mal.)
                                                                          */
  FILE *ifp;                                /* file pointer of source file*/
  int  *count;				    /* number of lines in source  */
{
  char line[81];
  char prefix[81];
  int j;

  *count = 0;
  for(j=0;j<1000;++j)
    srclabel[j] = (char *) NULL;
  while(fgets(line,80,ifp) != (char *) NULL)
    {
     sscanf(line,"%[^:]",prefix);
     if(strlen(prefix) == strlen(line))
       {strcpy(&(mal[*count][0]),line);
       }
     else
        /* check to be sure that this isn't a comment line
           with a colon embedded in it.                    */
       if(iscomment(prefix))
          {strcpy(&(mal[*count][0]),line);
          }
       else
       if(strlen(prefix) > 0)
        {strcpy(&(mal[*count][0]),line+strlen(prefix));
         srclabel[*count] = (char *) malloc(strlen(prefix)+1);
         strcpy(srclabel[*count], prefix);
        }
       else
        {fprintf(stderr,"error: nothing before colon on line %d\n",*count+1);
         fprintf(stderr,"exiting program\n");
         return 0;
        }
     ++(*count);
     if(*count >= 1000)
       {fprintf(stderr,"fatal error -- program longer than 1000 lines!\n");
        return 0;
       }
    }
  return 1;
}
/**************************************************************************/
iscomment(line)
/**************************************************************************/
   char line[];
{  int j;
   int incomment;
   int len;

   len = strlen(line);
   incomment = 0;
   for(j=0;j<len;++j)
     {switch(line[j])
       {case '{': incomment = 1;
                  break;
        case '}': incomment = 0;
                  break;
        default:;
       }
     }
   return incomment;
}
/**************************************************************************/
makelineno(srclines)
/**************************************************************************/
/*
    for all old labels, make corresponding new labels that are in
    ascending order.
                                                                          */
   int srclines;                             /* number of lines in source */
{  int j, newcount;
   char label[4];

   for(j=0;j<1000;++j)
      newlabel[j] = (char *) NULL;
   newcount = 0;
   for(j=0;j<srclines;++j)
     if(srclabel[j] != (char *) NULL)
        {sprintf(label,"%d",newcount);
         newlabel[j] = (char *) malloc(sizeof (label) +1);
         strcpy(newlabel[j], label);
         ++newcount;
        }
}
/**************************************************************************/
wrfilenswap(fullmal,ifp,nlines)
/**************************************************************************/
/*  1. Write edited source to a temporary file
        if comment or blank line, write it out unedited.
        if line of code
              a.  write out new label
              b.  use fixgotos() to substitute the new label
                  for the old on all gotos.
    2. If step one is successful, overwrite the original original
       source file with the edited one
                                                                          */
char *fullmal;                               /* original source file name */
FILE *ifp;                                /* original source file pointer */
int  nlines;                                    /* number of source lines */
{
   FILE *ofp;
   int  j;
   char tempfile[80];
   char line[81];
   char new[81];
   char cmd[81];

   strcpy(tempfile,fullmal);
   strcat(tempfile,".temp");
   if((ofp = fopen(tempfile,"w")) == (FILE *) NULL)
     {fprintf(stderr,"error trying to open temporary file %s \n");
      fprintf(stderr,"exiting the renumbering stage\n");
      return 0;
     }
   for(j=0;j<nlines;++j)
    {
     if(newlabel[j] == (char *) NULL)
        fputs(&(mal[j][0]),ofp);
     else
       {if(!fixgotos(new,&(mal[j][0]),j))
          return 0;
        strcpy(line,newlabel[j]);
        strcat(line,new);
        fputs(line,ofp);
       }
    }
   fclose(ifp);fclose(ofp); 
         /* overwrite fullmal with contents of tempfile */
   domove(tempfile,fullmal);  
   printf("renumbering successful -- %s updated \n",fullmal);
   return 1;
}
/**************************************************************************/
fixgotos(new,old,currentline)
/**************************************************************************/
   char *new;
   char *old;
   int  currentline;
{
  int j,len,where,last;
  char label[10], temp;

  len = strlen(old);
  *new = '\0';
  for(j=0;j<len;++j)
    if(*(old+j) == 'g')
      if(!strncmp(old+j,"goto",4))
          /* found goto. copy everything from beginning upto and 
             including the word 'goto'                            */
        {temp = *(old+j+4);
         *(old+j+4) = '\0';
         strcat(new,old);
         strcat(new," ");
         *(old+j+4) = temp;
          /* find the label -- the token after 'goto' and before
             the semicolon                                        */
         picklabel(old,j+4,label,&last,currentline);
          /* find the physical source line where this label is
             defined                                              */
         where = getoldlabel(label);
         if(where < 0)
            {fprintf(stderr,"'%s' is not used as a label\n", label);
             fprintf(stderr,"problem occured at line %d \n", currentline+1);
             fprintf(stderr,"fatal error -- renumbering did not succeedd\n");
             return 0;
            }
           /* copy the corresponding new label                    */
         strcat(new,newlabel[where]);
         strcat(new,old+last);
         return 1;
        }
   /* here if there wasn't a goto */
   strcpy(new,old);
   return 1;
}
/**************************************************************************/
picklabel(old,start,label,end,currentline)
/**************************************************************************/
    char *old;
    int  start;
    char *label;
    int  *end;
    int  currentline;
{
   int j;
   int len;
   int count;

   for(j=0;j<10;++j)label[j] = '\0';
   count = -1;
   len = strlen(old);
   for(j=start;j<len;++j)
     {
      if(!isspace(*(old+j)))
        if(*(old+j) == ';')
          {*end = j;
           return 1;
          }
        else
          {if(count >= 10)
             {fprintf(stderr,
                   "'goto' label too long on line %d \n",currentline+1);
              fprintf(stderr,"fatal error -- renumbering did not succeed\n");
              return 0;
             }
           ++count;
           *(label+count) = *(old+j);
          }
      }
    fprintf(stderr, "line number %d does not end with a semicolon\n",
                              currentline+1); 
    fprintf(stderr,"fatal error -- renumbering did not succeed\n");
    return 0;
}
/**************************************************************************/
getoldlabel(label)
/**************************************************************************/
  char *label;

{  int j;
  
   for(j=0;j<1000;++j)
    if(srclabel[j] != (char *) NULL) 
      if(!strcmp(srclabel[j],label))
           return j;
   return -1;
}
