#define max(x,y) ((x)<(y)?(y):(x))
#define min(x,y) ((x)>(y)?(y):(x))

void setbit(base,loc,begin,end,value)
/*
    given a value, and beginning and ending bit positions, 
    put value into specified bit locations.  The physical
    words are only 16 bits, so we will break bit strings
    along word boundaries
                                                              */
int *base;
int loc;
int begin,end;
int value;
{
  void setthisword();
  int bitproc,nbits,totbits;
  int bw,ew;
  int bpos,epos;
  int j;

  bitproc = 0;
  totbits = end-begin + 1;
  bw = begin/16;
  ew = end /16;
  
  for(j=bw;j<=ew;++j)
   {bpos = (max(begin,j*16)) % 16;
    epos = (min((j+1)*16-1,end)) % 16;
    nbits = epos - bpos + 1;
    bitproc += nbits;
    setthisword(base,loc+j,bpos,epos,value>>(totbits-bitproc));
   }
}
void setthisword(base,loc,begin,end,value)
/*
   guaranteed that beginning, and ending bit locations are
   in this word
                                                             */
int *base;
int loc;
int begin,end;
int value;
{
  int mask,mvalue;
  void makemask();

  makemask(end-begin+1,&mask);
  mvalue = 0x0ffff & ((mask & value) << (15-end));
  mask = 0x0ffff & ~(mask << (15-end));
  base[loc] = base[loc] & mask;  
  base[loc] = base[loc] | mvalue;
  return;
}
void makemask(nbits,mask)
int nbits;
int *mask;
{
  int j;
  
  *mask = 0;
  for(j=0;j<nbits;++j)
    *mask = *mask | (1 << j);
}

