#include <stdio.h>
#include "user.h"
#include "arch.h"

extern int traceregs[24];
extern int arch_level;

#define NO  -1
#define YES  1

void response();

int trace(un)
/*
   sets flags in traceregs to determine which registers
   will be printed during the next "step" or "go"
                                                           */
 int un;
{ 
  char str[80], str2[80];
  int value, l2name;

  if(span_white() == 0)
     {response("trace what?");
      fflush(stdin);
      return 0;
     }
  get_string(str); 
  if(arch_level == MACRO)
   {value = ismacreg(str,&l2name);
    if(value != NO)
     traceregs[value] = un;
    else
     {sprintf(str2,"%s not a valid level-2 register", str);
      response(str2);
     }
    fflush(stdin);
    return 0;
   }
  else          /* micro level -- ask about three classes of regs */
   { value = isspr(str);
     if(value != NO)
       {traceregs[value] = un;
        fflush(stdin);
        return 0;
       }
     value = isoreg(str);
     if(value != NO)
       {traceregs[value +16] = un;
        fflush(stdin);
        return 0;
       }
     value = ismir(str);
     if(value != NO)
       {traceregs[16 + 7] = un;
        fflush(stdin);
        return 0;
       }
     sprintf(str2,"%s not a valid level-1 register",str);
     response(str2);
     fflush(stdin);
     return 0;
   }
}
