typedef struct FIELD             /* field within an instruction word */
   { char fname[20];             /* field name                       */
     int begin,end;              /* bit positions in instruction word*/
     int key,punct,constant,reg;
                                 /* == 1 -> token legal in this field*/
     struct FIELD *next;         /* points to next field             */
   } FIELD ;
typedef struct                   /* an instruction format            */
   { FIELD *f;                   /* ptr to linked list of fields     */
     int nfields;                /* number of fields in the instr.   */
     int nwords;                 /* number of 16-words occupied      */
   } INSTR_FORMAT;
typedef struct                   /* name table entry for registers   */
   { char sym[8];                /* register name                    */
     int value;                  /* value for assembled instruction  */
     int sprno;                  /* scratchpad register it will use  */
   } REG_ENTRY;
typedef struct                   /* name table for registers         */
   { int nregs;
     REG_ENTRY regtup[16];
   } LEVEL2_REGS;
typedef struct			 /* name table entry for opcodes     */
   { char sym[8];		 /* opcode symbol                    */
     int value;                  /* opcode value                     */
     int format;                 /* instruction format               */
   } OPCODE_ENTRY;
typedef struct		         /* opcode table                     */
   { int n;                      /* number of valid entries          */
     OPCODE_ENTRY op[500];       /* table                            */
   } OPCODE_TABLE;
typedef struct                   /* symbol - value pair              */
   { char sym[8];
     int value;
   } SVP;
typedef struct                   /* punctuation table                */
   { int n;                      /* number of valid entries          */
     SVP p[60];                  /* table                            */
   } PUNCT_TABLE;



