#include <string.h>
#include <stdio.h>
#include "arch.h"
#include "user.h"
#define BREAK   0
#define EXAMINE 1
#define SET     2
#define UNTRACE 3
#define TRACE   4
#define STEP    5
#define GO      6
#define MAC     7
#define MIC     8
#define LOAD    9
#define QUIT   10
#define HELP   11
#define DETAIL 12
#define STATS  13
#define SHELL  14
#define KEYERR -1

#define NO     -1
#define YES     1

void response(), get_range();
void get_letter(), get_string(), convert_lc();
/*
   global variables set by user.  These control the interaction
   between interaction and user
                                                                 */
int break_addr;              /*  breakpoint address              */
int break_on;                /*  0 = no, 1 = yes                 */
int arch_level;              /*  running at micro(1) or macro(2) */
int single_step;
int traceregs[24];           /*  determine which regs are printed*/
int stop_instruction;        /*  stop instruction reached in l2  */
int stats;                   /*  =1 -> collect & print statistics*/
int nwfetches, nwstores,
           cycles1, cycles2; /*  mac mem fetches, mic,mac cycles */

/*
   variables of the architecture that are affected by user 
   commands are listed here
                                                                 */
extern char *sprnames[16];
extern char *ornames[7];
extern SCRATCHPAD oreg[7];
extern SVP regt[16];
extern nummacregs;

int proc_aline()
/*
   responsible for processing one line of user input.  
   Returns  -1: catastrophic error 0: still soliciting input
             1: go!
                                                        */
{
  int keyword, status;

  status = span_white();
  if(status <=0) return status;
  keyword = get_token();
  switch(keyword)
  {
    case BREAK:  return proc_break();
    case EXAMINE:return proc_examine();
    case SET:    return proc_set();
    case UNTRACE:return proc_untrace();
    case TRACE:  return proc_trace();
    case DETAIL: return proc_detail();
    case STEP:   return proc_step();
    case GO:     return proc_go();
    case MAC:    return proc_mac();
    case MIC:    return proc_mic();
    case LOAD:   return proc_load(0);
    case QUIT:   return proc_quit();
    case HELP:   return proc_help();
    case STATS:  return proc_stats();
    case SHELL:  return proc_shell();
    case KEYERR: 
    default:     response("unrecognized command");
                 fflush(stdin);
                 return 0;
  }
}
/******************************************************************/
int proc_break()
/******************************************************************/
/*
  processes user request for a breakpoint
                                                                  */
{ char str[80]; 
  int value; 
  void get_number();
  
  if(span_white() == 0)
    {response("must supply an address");
     fflush(stdin);
     return 0;
    }
  get_number(str);
  if(str[0] == '\0')
    {response("breakpoint address must be numeric");
     fflush(stdin);
     return 0;
    }
  value = makeint(str);
  if(arch_level == MICRO)
    if(0<=value && value <= LENGTHCS)
      {break_on = YES;
       break_addr = value;
       fflush(stdin);
       return 0;
      }
    else
      {sprintf(str,"%d not legal address in control store",value);
       break_on = NO;
       response(str);
       fflush(stdin);
       return 0;
      }
   else  /* level-2 architecture */
     if(0<= value && value <= LENGTHMAC)
       {break_addr = value;
        break_on = YES;
        fflush(stdin);
        return 0;
       }
     else
       {sprintf(str,"%d not legal address in memory",value);
        break_on = NO;
        response(str);
        fflush(stdin);
        return 0;
       }
}
/******************************************************************/
int proc_examine()
/******************************************************************/
{char str[80], str2[80];
 int value,val1,val2, j;
 int l2name;
 char ch;

 if(span_white() == 0)               /* check for an argument */
  {response("examine what?");
   fflush(stdin);
   return 0;
  }
 get_string(str); convert_lc(str);
 if(arch_level == MACRO)         /*  we're at level-2 in arch  */
  {value = ismacreg(str,&l2name);     
   if(value != NO)
     {examine_mac(value,l2name); /*  user specified a register */
      fflush(stdin);
      return 0;
     } 
   ch = str[0];
   if(isdigit(ch))
     {get_range(str,&val1,&val2);     /* specifying memory locs*/
      if(isvalid_range(val1) && isvalid_range(val2))
        if (val1 < val2) 
           for(j=val1;j<=val2;++j)
             dump_mac(j);
        else
           for(j=val1;j>=val2;--j)
            dump_mac(j);
      fflush(stdin);
      return 0;
     }
   sprintf(str2,"%s is not a valid level-2 register or memory location",str);
   response(str2);
   fflush(stdin);
   return 0;
  }
 else                 /*   -- here for level-1 inquiries   */
  {value = isspr(str);
   if(value != NO)
     {
      examine_mic(value,0);   /* user specified scr-pad reg*/
      fflush(stdin);
      return 0;
     }
   value = isoreg(str);
   if(value != NO)
     {examine_mic(value, 1); /*    specified other mic reg*/
      fflush(stdin);
      return 0;
     }
   if(ismir(str) != NO)
     {examine_mic(0,2);      /*    specified mir          */
      fflush(stdin);
      return 0;
     }
   ch = str[0];
   if(isdigit(ch))
     {get_range(str,&val1,&val2);/* specifying memory locs*/
      if(isvalid_range(val1) && isvalid_range(val2))
        if (val1 < val2) 
           for(j=val1;j<=val2;++j)
             dump_mic(j);
        else
           for(j=val1;j>=val2;--j)
            dump_mic(j);
      fflush(stdin);
      return 0;
     }
   sprintf(str2,
        "%s not a valid level-1 register or control-store location",str);
   response(str2);
   fflush(stdin);
   return 0;
  }
}
/******************************************************************/
int isvalid_range(r1)
/******************************************************************/
 int r1;
{                           /*  checking that user-supplied address  */
  char str[80];             /*  actually exists in the hardware      */
  int ul;

  if(arch_level == MACRO)
   ul = LENGTHMAC;
  else
   ul = LENGTHCS;
  if(0 <= r1 && r1 < ul)
    return 1;
  sprintf(str,"%d not a valid memory address",r1);
  response(str);
  return 0;
}
/******************************************************************/
void get_range(str,val1,val2)
/******************************************************************/
 char *str;
 int *val1,*val2;
{
 char ch;
 *val1 = makeint(str);
 if(span_white() <= 0)   
  {*val2 = *val1;    /* only one address specified */
   return;
  }
 ch = getc(stdin);
 if (ch != '-')
   if(ch != ' ')
    {*val2 = *val1;
     return;
    }
 if(span_white() <= 0)
   {*val2 = *val1;  /* I'm such a nice, forgiving type of person */
     return;
   }
 get_string(str);
 ch = str[0];
 if(isdigit(ch))
   *val2 = makeint(str);
 else
   *val2 = *val1;
 return;
}

/******************************************************************/
int ismacreg(sym,l2name)
/******************************************************************/
char *sym;
int *l2name;
{
   int j;
   convert_lc(sym);
   for(j=0;j<nummacregs;++j)
     {
      if(!strcmp(sym,regt[j].sym))
           {*l2name = j;
            return regt[j].value;
           }
     }
   return -1;
}
/******************************************************************/
   int isspr(str)
/******************************************************************/
  char *str;
{ int j, slen;
  char *temp;

  convert_lc(str); 
  slen = strlen(str);
  temp = (char *) calloc(slen+3,sizeof(char));
  strcpy(temp,str);
  strcat(temp," ");
  if(slen < 6) ++slen;
  for(j=15;j>-1;--j)
    if(!strncmp(temp,sprnames[j],slen))
      {free(temp);
       return j;
      }
  free(temp);
  return -1;
}
/******************************************************************/
int isoreg(str)
/******************************************************************/
  char *str;
{ int j, len;

  convert_lc(str);
  len = strlen(str);
  for(j=0;j<7;++j)
    if(!strncmp(str,ornames[j],len))return j;
  return -1;
}
/******************************************************************/
int ismir(str)
/******************************************************************/
  char *str;
{
  convert_lc(str);
  if(!strncmp(str,"mir",2))return 0;
  return -1;
}
/******************************************************************/
int proc_untrace()
/******************************************************************/
{
  trace(NO);
  return 0;
}
/******************************************************************/
int proc_trace()
/******************************************************************/
{ trace(YES);
  return 0;
}
/******************************************************************/
int proc_step()
/******************************************************************/
{ 
  single_step = YES;
  fflush(stdin);
  return 1;
}
/******************************************************************/
int proc_go()
/******************************************************************/
{ 
  single_step = NO;
  fflush(stdin);
  return 1;
}
/******************************************************************/
int proc_mac()
/******************************************************************/
{
    arch_level = MACRO;
    oreg[MPC] = 0;
    break_on = NO;
    level4(NO);
  fflush(stdin);
  return 0;
}
/******************************************************************/
int proc_mic()
/******************************************************************/
{
  arch_level = MICRO;
  break_on = NO;
  level4(NO);
  fflush(stdin);
  return 0;
}
/******************************************************************/
int proc_quit()
/******************************************************************/
{
  exit(0); 
}
/******************************************************************/
int proc_stats()
/******************************************************************/
{ char str[80];

  if(span_white() == 0)
   {response("on or off?");
    fflush(stdin);
    return 0;
   }
  get_string(str);
  if(!strncmp(str,"on",2))
    {stats = YES;
     cycles1 = 0;
     cycles2 = 0;
     nwfetches = 0;
     nwstores = 0;
     fflush(stdin);
     return 0;
    }
  if(!strncmp(str,"of",2))
    {stats = NO;
     cycles1 = 0;
     cycles2 = 0;
     nwfetches = 0;
     nwstores = 0;
     fflush(stdin);
     return 0; 
    }
  response("must specify 'on' or 'off'");
  fflush(stdin);
  return 0;
}
/******************************************************************/
int proc_help()
/******************************************************************/
{
  fflush(stdin);
  dohelp();
  return 0;
}
/******************************************************************/
int get_token()
/******************************************************************/
/*
   recognizes the keyword command as supplied by the user 
                                                                  */
{
  char str[50];
  char ch;
 
  get_letter(str); convert_lc(str);
  if(!strncmp(str,"br",2)) return BREAK;
  if(!strncmp(str,"ex",2)) return EXAMINE;
  if(!strncmp(str,"un",2)) return UNTRACE;
  if(!strncmp(str,"tr",2)) return TRACE;
  if(!strncmp(str,"de",2)) return DETAIL;
  if(!strncmp(str,"se",2)) return SET;
  if(!strncmp(str,"ste",3)) return STEP;
  if(!strncmp(str,"go",2)) return GO;
  if(!strncmp(str,"as",2)) return MAC;
  if(!strncmp(str,"mi",2)) return MIC;
  if(!strncmp(str,"lo",2)) return LOAD;
  if(!strncmp(str,"qu",2)) return QUIT;
  if(!strncmp(str,"sta",3)) return STATS;
  if(!strncmp(str,"he",2)) return HELP;
/*  but wait, maybe it's an escape to the shell */
  ch = getc(stdin);
  if(ch == '!')            return SHELL;
  return KEYERR;
}
