#include <string.h>
#include <stdio.h>
#include "arch.h"
#include "user.h"

#define NO     -1
#define YES     1

void response(), get_range();
void get_letter(), get_string(), convert_lc();
/*
   global variables set by user.  These control the interaction
   between simulator and user
                                                                 */
extern int arch_level;       /*  running at micro(1) or macro(2) */

/*
   variables of the architecture that are affected by user 
   commands are listed here
                                                                 */
extern SCRATCHPAD mpc;

  void get_number();
  void response(), get_range();
  void get_letter(),get_string(), convert_lc();
  
/******************************************************************/
int proc_set()
/******************************************************************/
{char str[80], str2[80];
 int value,val1,val2, addr, l2name;
 char ch;

 if(span_white() == 0)             /* check for an argument */
  {response("set what?");
   fflush(stdin);
   return 0;
  }
 get_string(str); convert_lc(str);
 if(arch_level == MACRO)      /*  we're at level-2 in arch  */
  {addr = ismacreg(str,&l2name);     
   if(addr != NO)
     {if(validhex(&val1) != NO)
       {set_mac_reg(addr,val1); /*  user specified a register */
       }
      fflush(stdin);
      return 0;
     } 
   ch = str[0];
   if(isdigit(ch))
     {addr = makeint(str);    /* user is specifying memory  */
      if(isvalid_range(addr))
        if(validhex(&val1) != NO)
           { set_mac_mem(addr,val1);
           }
      fflush(stdin);
      return 0;
     }
   sprintf(str2,"%s is not a valid level-2 register or memory location",str);
   response(str2);
   fflush(stdin);
   return 0;
  }
 else                         /*   -- here for level-1 inquiries   */
  {
   value = isspr(str);
   if(value != NO)            /*  specified scratchpad register    */
     {if(validhex(&val1) != NO)
         {set_mic_register(0,value,val1);
         }
      fflush(stdin);
      return 0;
     }
   value = isoreg(str);
   if(value != NO)
     { if(validhex(&val1) != NO)     /*    specified other mic reg*/
          {set_mic_register(1,value,val1);
          }                                
      fflush(stdin);
      return 0;
     }
   if(ismir(str) != NO)
     {                              /*    specified mir          */
      response("manual modification of mir not allowed");
      fflush(stdin);
      return 0;
     }
   ch = str[0];
   if(isdigit(ch))                  /*    specified c.s. location*/
     {response(" manual modification of control store not allowed");
      fflush(stdin);
      return 0;
     }
   sprintf(str2,
        "%s not a valid level-1 register or control-store location",str);
   response(str2);
   fflush(stdin);
   return 0;
  }
}
int validhex(num)
 int *num;
{
  int sum;
  char str[80],str2[80];
  int j, hex;

  if(span_white() == 0)
   {response("no value specified");
    return NO; 
   }
  
  get_string(str); convert_lc(str);
  hex=0;
  if(str[0] == 'x')hex = 1;
  if(str[0] == '0' && str[1] == 'x') hex = 2;
  if(!isdigit(str[0]) && hex == 0)
    {sprintf(str2," %s is not a numeric value",str);
     response(str2);
     return NO;
    }
   
  j = 0;
  while(str[j+hex] != '\0')
    {str[j] = str[j+hex];
     ++j;
    }
  str[j] = '\0';
  sum = 0;
  j = 0;
  if(!hex)
    {*num = makeint(str);
     return YES;
    }
  while(str[j] != '\0')
    {if(isdigit(str[j]))
         sum = sum * 16 + (str[j] - '0');
     else
        if('a' <= str[j] && str[j] <= 'f')
           sum = sum * 16 + ( (int)(str[j] - 'a') + 10);
        else
           {sprintf(str2,"%s is not a valid hex number\n",str);
            return NO;
           }
     ++j;
    }
  *num = sum;
  return YES;
}
  
