#include "arch.h"
#include "user.h"

#define YES   1
#define NO   -1

void ex_mac_instr();
void print_regs(), solicit_user(), print_stats();
void ex_mac_prog(), ex_mac_instr(), ex_mic_instr();

extern MACINSTRUCTION mac[LENGTHMAC];
extern int single_step;
extern int break_on;
extern int break_addr;
extern int arch_level;
extern int traceregs[24];
extern int stats,cycles1,cycles2, nwfetches, nwstores;
extern SCRATCHPAD spr[16];
extern SCRATCHPAD oreg[7];
extern MICROINSTRUCTION mir;
extern char *sprnames[16];
extern char *ornames[7];
extern int nummacregs;
extern SVP regt[16];

/*****************************************************************/
void ex_mac_prog()
/*****************************************************************/
{
/*
    level-2 (macro, conventional-machine level) simulator
    after executing a level-2 instruction, check to see if
    we're tracing registers.  If so, print them out.  The
    function "stopping"  is true if the next level-2
    instruction is STOP  (0xffff), or if the user has
    specified single-step mode (STEP) or if the pc
    contents are equal to the breakpoint ( and breakpoint is set)
                                                                  */
  while (1)
   {ex_mac_instr();
    if(arch_level == MACRO)
      {if(tracing()) print_regs();
       if(stopping()) solicit_user();
      }
    else
      if(stopped()) solicit_user();
    }
}
/*****************************************************************/
int tracing()
/*****************************************************************/
/*  
    check to see if any of the trace flags are set
                                                                 */
{
  int j;

  if(arch_level == MACRO)
   {for(j=0;j<=nummacregs;++j)
      if(traceregs[regt[j].value] == YES) return 1;
    return 0;
   }
  else             /* more regs in level-1 arch!                */
   {for(j=0;j<24;++j)
      if(traceregs[j] == YES) return 1;
    return 0;
   }
}
/*****************************************************************/
void print_regs()
/*****************************************************************/
{
  int j;
  char str[80],str2[70], str3[80];
  char sym[8], opcode[8];
  int n, k;
  void macname(), print_cycles();

  n = 0;
  for(j=0;j<23;++j)
    {str[0] = '\0';
     if(traceregs[j] == YES)
      {if(j<16)
        {if(arch_level == MACRO)
          {macname(j,sym);
           strcat(str,sym);
          }
         else
           strcat(str,sprnames[j]);
         strcat(str,": ");
         bit_string(str2,(int)spr[j],(sizeof( SCRATCHPAD) * 8));
        }
       else
        {strcat(str,ornames[j-16]);
         strcat(str,": ");
         if(j<16+5)
            bit_string(str2,(int)oreg[j-16],(sizeof(SCRATCHPAD) * 8));
         else
            sprintf(str2,"%1x                ",(int)oreg[j-16]);
        }
        strcat(str,str2);
        /* handle the IR specially */
        if(arch_level == MICRO && j == IR)
            {get_opc((int)spr[j],opcode);
             strcat(str,opcode);
            }
        if(n == 0)
          {
           strcpy(str3,str);
           for(k=strlen(str3);k<40;++k) str3[k] = ' ';
           str3[40] = '\0';
           ++n;
          }
        else
          {strcat(str3,str);
           response(str3);
           n = 0;
          }
      }  
     }
  if(n == 1) response(str3);
  str[0] = '\0';
  if(arch_level == MICRO && traceregs[23] == YES)
     {strcat(str, "mir: ");
      disassemble(mir,str2);
      strcat(str,str2);
      response(str);
     }
 if(stats == YES) print_stats();
 return;
}
/*****************************************************************/
void print_stats()
/*****************************************************************/
{ char str[50];

  sprintf(str,"mpc cycles: %d pc cycles: %d",cycles1,cycles2);
  response(str);
  cycles1 = 0;
  cycles2 = 0;
  sprintf(str,"assembly words fetched %d", nwfetches);
  response(str);
  nwfetches = 0;
  sprintf(str,"assembly words stored %d", nwstores);
  response(str);
  nwstores  = 0;
  return;
}
/*****************************************************************/
int bit_string(str,value,len)
/*****************************************************************/
/*
  given an integer (value), creates a character string
  that presents the integer in binary
                                                                 */
char *str;
int value,len;
{ 
  char aux[40];
  int j, kopy;

  kopy = value;
  for(j=0;j<len;++j)
  { 
    aux[len-j-1] = (char)((kopy & 0x01) + '0');
    kopy =  kopy >> 1;
  }
  kopy = 0;
  for(j=0;j<len;++j)
    {str[kopy++] = aux[j];
     if((j+1) % 4 == 0)
        str[kopy++] = ' ';
    }
  str[kopy] = '\0';
}
/*****************************************************************/
void macname(sp,sym)
/*****************************************************************/
/*  
   given a scratchpad register index, find the corresponding
   level-2 name for the scratchpad
                                                                 */
int sp;
char *sym;
{
   int j;
   static char str[2] = " ";

   for(j=0;j<nummacregs;++j)
     if(regt[j].value == sp)
      {strcpy(sym,regt[j].sym);
       return;
      }
   strcpy(sym,str);
   return;
}
/*****************************************************************/
int stopping()
/*****************************************************************/
/*
   are we stopping before executing the next instruction?
                                                                 */
{
  if(arch_level == MACRO)
   { if(mac[spr[0]] == 0xffff)    /* is next instruction a stop? */
      {response("STOP instruction encountered");
       if((stats == YES) && !tracing())print_stats();
       return 1;
      }
     if(break_on == YES)          /* check for breakpoint        */
       if(break_addr == spr[0])   /* compare with pc (spr[0])    */
           {break_on = NO;        /* we've hit the breakpoint    */
            response("breakpoint reached");
            if((stats == YES)&& !tracing())print_stats();
            return 1;             /* reset it and return         */
           }
     if(single_step == YES)       /* are we in single-step mode? */
       { if((stats == YES) && !tracing())print_stats();
         return 1;
       }
     return 0;                    /* must be in "run" mode       */
   }
  else                            /* at level 1 in arch          */
   { if(single_step == YES)       /* checking for single-step    */
         return 1;
     if(break_on == YES)          /* breakpoint? */
       if(break_addr == oreg[4])  /* check value w/ mpc (oreg[4])*/ 
          {break_on = NO;
           response("breakpoint reached");
           return 1;
          }
     return 0;                    /* must be in "run" mode       */
   }
}
/*****************************************************************/
int stopped() 
/*****************************************************************/
/*
  even if we're not operating at MAC level, we'll still need
  to ask if we've reached a STOP instruction
                                                                 */
 { if(mac[spr[0]] == 0xffff)    /* is next instruction a stop?   */
    {response("STOP instruction encountered");
      return 1;
    }
   return 0;
 }
/*****************************************************************/
void ex_mac_instr()
/*****************************************************************/
/*
   main driving routine at the microarchitecture level
   archicture executes multiple mic instructions.  If user
   has specified STEP or a breakpoint address that matches
   curent mpc, simulator solicits commands from user.

   Convention: When the mpc is once again zero, we assume that
   the level-1 arch has finished the fetch-decode-execute
   cycle that interprets the current level-2 instruction
                                                                */
{
  do
   {ex_mic_instr();
    if(arch_level == MICRO)
      {if(tracing())print_regs();
       if(stopping())solicit_user();
      }
   }while (oreg[4] != 0);
  return;
}
