#include <stdio.h>
#include <string.h>
#include <ctype.h>

extern srclines, kfield, kformat;
/*****************************************************************/
void proc_other(line,fp)
/*****************************************************************/
char *line;
FILE *fp;
/* 
   processes all field declarations except the opcode
                                                                 */
{
   char fname[40], symbol[40];
   int begin,end, value, nch, nch2;
   int key,con,punct,reg;
   int status;
   char ch, pstr[2];
   void parse_dir(), convert_lc(), proc_punct(), proc_null();
   int ich;

   key = 0;
   con = 0;
   punct = 0;
   reg = 0;

/*
   get field name, beginning and ending bit positions
                                                                 */
   parse_dir(line,fname,&begin,&end);
/*
   get info about this field until we hit another declaration
                                                                 */
loop:
   if(feof(fp))
      {tods(begin,end,key,punct,con,reg,fname);
       ++kfield;
       return;
      }
   ich = fgetc(fp);
   if(ich == EOF)
      {tods(begin,end,key,punct,con,reg,fname);
       ++kfield;
       return;
      }
   ch = ich;
   ungetc(ch,fp);
   if(ch == '#')   /* we've hit another declarations            */
      {if(!(punct || key || con || reg))
         error("no values specified for previous instruction field");
       tods(begin,end,key,punct,con,reg,fname);
       ++kfield;
       return;
      }
   fgets(line,81,fp);++srclines;convert_lc(line);
   if(ch == ';') goto loop;                /* comment line      */
   nch = 0;
   status = an_str(line,&nch,symbol);
   if(status < 0) goto loop;               /* blank line        */
   if(status == 0)       
    {nch2= 0;    /* didn't find alphanumeric, try finding punct */
     status = get_punct(line,&nch2,pstr); /* process punctuation*/
     if(status <= 0)             
       {error("first nonblank in line is not alpha, numeric or punctuation!");
        goto loop;
       }
     if(!(reg || con || key))     /* is punctuation legal here? */
       {punct = 1;
        proc_punct(line);
        goto loop;
       }
     else
        error("can't use punct as a symbol in conjunction with alpha symbols");
     goto loop;
    }                               /* end process punctuation  */
/*
  we found an alphanumeric string with the an_str call.  Check
  if it's a special string.
                                                                */
 if(punct)
   if(!strncmp(symbol, "null", 4))
     {proc_null(line+nch); 
      goto loop;
     }
   else
   {error("can't use alpha symbols in conjunction with punctuation symbols");
    goto loop;
   }
 if(!strncmp(symbol,"registers",9))
     {reg = 1;
      goto loop;
     }
 if(!strncmp(symbol,"labels",6))
     {con = 1;
      goto loop;
     } 
 if(!strncmp(symbol,"null",4))
   {if(!(reg || con || key))
     {punct = 1;
      proc_punct(line);
     }
    else
     error("can't use 'null' keyword in conjunction with alpha symbols");
    goto loop;
   }
/*
  it's not a reserved word.  must be a symbol -- value pair
                                                                      */
 if(get_num(line,&nch,&value) < 1)
   {error("symbol value is missing or nonnumeric");
    goto loop;
   }
 if(strlen(symbol) > 7)
   {warning("symbol has been truncated to 7 characters");
    symbol[7] = '\0';
   }
 tooptable(symbol,value,0);
 goto loop;
}
/*****************************************************************/
void proc_punct(line)
/*****************************************************************/
char *line;
/*
   retrieves punctuation -- value pair
                                                                 */
{  int nch, value;
   char pstr[2];

   nch = 0;
   get_punct(line,&nch,pstr);
   if(r_punct(pstr))
     {error("illegal use of reserved punctuation symbol");
      return;
     }
   if(get_num(line,&nch,&value) < 1)
     {error("nonnumieric or missing value");
      return;
     }
   topuncttable(pstr,value);
   return;
}
/*****************************************************************/
int r_punct(str)
/*****************************************************************/
/*
    is str a reserved punctuation?
                                                                 */
char *str;

{ static char *punct[] = {"(", "+", ")", "-", ";", ","};
  int j;  
 
  for(j=0;j<6;++j)
   if(!strncmp(str,punct[j],1)) return 1;
  return 0;
} 
/*****************************************************************/
void proc_null(line)
/*****************************************************************/
/*
   we know that the first string is "null".  find the value
   associated with "null"
                                                                 */
char *line;
{
  int value;
  int nch;

  nch = 0;
  if(get_num(line, &nch, &value) < 1)
    {error("nonnumeric or missing value for 'null'");
     return;
    }
  tooptable("null",value,0);
  return;
}
