/*
    The meta assembler ("meta") is a component of IST, and is 
    exec'd from "assem".  "meta" takes user-defined instruction
    set architectures as input and generates the tables needed
    by the assembler ("assem").  "meta" produces a file called
    "instr.set" that the assembler uses to define its register
    structure and instruction set formats and keywords.  "meta"
    also produces a file called "instr.log" that lists the
    instruction set format, and errors (if they occur)
                                                         rjn
                                                                    */
#include <stdio.h>
main(argc,argv)
int argc;
char *argv[];
{
  extern int srclines;
  FILE * psource, *pobj;
  void proc_regs(), proc_inst(), print_regs(), print_format();

  srclines = 0;
  initialize();
  psource = fopen(argv[1], "r");
  if(psource == (FILE *) NULL)
    {fprintf(stderr,"can't open %s for input \n", argv[1]);
     exit (1);
    }
  printf("processing instruction set definitions on %s \n",
         argv[1]);
  proc_regs(psource);                /* process register definitions */
  print_regs();                      /* print to "instr.log" file    */
  proc_inst(psource);                /* process instruction formats  */
  fclose(psource);
  finish_format();                   /* reconcile instruction formats*/
  pr_format();                       /* print to "instr.log" file    */
  pobj = fopen("instr.set", "w");
  if(pobj == (FILE *) NULL)
    {fprintf(stderr, 
             "can't open %s for output\n", "instr.set");
     exit(1);
    }
  dump_format(pobj);                 /* store defns on "instr.set"   */
  exit(0);
}

