/*
   program to compile mal into microprogram code ("ma").
   "ma" takes one argument, which is a pathname for a
   microprogram source.  The pathname is assumed to have
   a ".mal" extension.  After checking for the time stamp, 
   and renumbering the lines, "ma" passes the input to 
   yyparse(), which parses the source and generates the
   object.  Object files have ".mic" extension.
   yyparse() was generated using yacc.
                                                    rjn 19 july 90
                                                                   */
#include <stdio.h>
#include "micstr.h"
#include "mytokens.h"

extern int yydebug;
extern MICROINSTRUCTION instr;		/* current microinstr.word */
FILE *pobj;				/* object file             */
FILE *psrc;				/* source file		   */
	
REF_TABLE refs[256];                    /* refences in source file */
int jref;				/* number of refs          */

extern int obj_lines;			/* lines of microcode      */	
int bomb;				/* =0 -> src syntax correct*/

main(argc,argv)
int argc;
char *argv[];
 { 
   void init_instr();
   int j, rtnvalue;
   char msg[80];
   char binary[80];
   char source[80];
   char line[80];

   if(argc < 2)
     {fprintf(stderr, "usage: ma <filename>\n");
      exit(1);
     }
   sprintf(source,"%s.mal",argv[1]);
   sprintf(binary,"%s.mic",argv[1]);
   if(dateok(source,binary))
      {printf("%s is up to date.\n",binary);
       exit(0);                      /* binary is up-to-date */    
      }
   if(!renum(argv[1]))               /* renumber source      */
        exit(1);
   psrc = fopen(source,"r");
   if(psrc == (FILE *) NULL)
      {fprintf(stderr, "can't open %s as source \n", source);
       exit(1);
      }
   pobj = fopen(binary,"w");
   if(pobj == (FILE *) NULL)
      {fprintf(stderr, "can't open %s as object file\n", binary);
       exit(1);
      }
   init_instr();
   bomb = 0;
   yyparse();       /* yyparse does parse and code generation */
                    /* check for valid references             */
   for(j=0;j<jref;++j)
     if(refs[j].ref >= obj_lines)
       {sprintf(msg,"%d: label %d does not reference a valid line",
                      refs[j].line, refs[j].ref);
        yyerror(msg);
        bomb = 1;
       }
   if(bomb)
    {yyerror("errors in source -- no microcode generated");
     fclose(pobj);
                 /* delete object that contains bad microcode */
     dounlink(binary);
     exit(1);
    }
   printf(" successful compilation of microcode\n");
   printf(" microcode object file written on %s \n", binary);
   exit(0);
 }
yyerror(s)
  char *s;
 { fprintf(stderr, "%s\n", s);
 }
