#include <string.h>
#include <ctype.h>

#define isarpunct(c) (((c)==')') || ((c)=='(') || ((c) == '+') || ((c)=='-'))

/**********************************************************************/
int get_ae(line,nch,str)
/**********************************************************************/
/*
   gets the next arithmetic expression
                                                                      */
char *line;
int *nch;
char *str;
{
  int j, legal,k;

  if(!span_comma(line,nch)) return 0;
  j = *nch;
  legal = 1;
  while((line[j] != '\0') && legal)
    {
     if(isalnum(line[j]))
        ++j;
     else
        if(isarpunct(line[j]))
           ++j;
        else
          legal = 0;
    }
  if(j == *nch) return 0;
  for(k= *nch;k<j;++k)
    str[k - *nch] = line[k];
  str[j - *nch] = '\0';
  *nch = j;
  return 1;
}
/**********************************************************************/
int get_num(str,nch,value)
/**********************************************************************/
char *str;
int *nch;
int *value;
/*
  starting with character nch, scans white space until we find an
  alphanumeric string.  We check to see if its
       0b* -- binary
       0x* -- hex
       0*  -- octal
    [1-9]* -- decimal
  if so, we convert it.  if not, we issue an error.
  function returns  1 -- success
		    0 -- something other than a number was encountered
                   -1 -- just white space to eol
                                                                      */
{ int status;
  char str2[80];
  void convert_lc();
  
  status = an_str(str,nch,str2);
  if(status <= 0) return status;
  /* we have a nonnul alphanumeric string */
  convert_lc(str2);
  /* binary? */
  if(!strncmp("0b",str2,2)) return make_num(str2+2,value,2);
  /* hex? */
  if(!strncmp("0x",str2,2)) return make_num(str2+2,value,16);
  /* octal? */
  if(!strncmp("0",str2,1)) return make_num(str2,value,8);
  /* decimal */
  return make_num(str2,value,10);
}
/**********************************************************************/
int make_num(str,value,base)
/**********************************************************************/
char *str;
int *value;
int base;
/* converts the character string in the given base to an integer
   function returns 1 -- successful conversion
                    0 -- invalid character in string
   having written this function in various guises for over 15 years
   now, it's slowly loosing its novelty
                                                                      */
{  int sum, j;
  
   if(!digits_ok(str,base)) return 0;
   sum = 0;
   j = 0;
   if(base < 11)
     while(str[j] != '\0')
       sum = sum*base + str[j++] - '0';
   else
     while(str[j] != '\0')
       if(isdigit(str[j]))
          sum = sum*base + str[j++] - '0';
       else
          sum = sum*base + (str[j++] - 'a' + 10);
   *value = sum;
   return 1;
}

#define isoctdigit(ch)  ('0' <=(ch) && (ch)<='7')
#define isbindigit(ch)  ('0' <=(ch) && (ch)<='1')
/**********************************************************************/
int digits_ok(str,base)
/**********************************************************************/
char *str;
int base;
/*
    checks that all the characters in str are valid in base base  
                                                                      */
{ int j;

  j = 0;
  switch(base)
    {case 2: while(str[j] != '\0')
                if(!isbindigit(str[j]))
                  return 0;
                else
                  ++j; 
             break;
     case 8: while(str[j] != '\0')
                if(!isoctdigit(str[j])) 
                  return 0;
                else
                  ++j;
             break;
     case 10:while(str[j] != '\0')
                if(!isdigit(str[j])) 
                  return 0;
                else
                  ++j;
             break;
     case 16:while(str[j] != '\0')
                if(!isxdigit(str[j])) 
                  return 0;
                else
                  ++j;
             break;
     default: return 0;
    }
  return 1;
}
/**********************************************************************/
int an_str(str,nch,str2)
/**********************************************************************/
char *str;
int *nch;
char *str2;
/*
   starting with character nch, scans white space until finding an
   alphanumeric characger.  Copies ensuing alphanumeric string into
   str2.  Leaves nch posiitioned one past the last character copied.
                                                                      */
{ int j;

  j = 0;
  str2[0] = '\0';
  if(!span_white(str,nch)) return -1;    /* was blank until eol       */
  if(!isalnum(str[*nch]))       /* nch points at a nonblank character */  
           return 0; 
  while(isalnum(str[*nch])) /* copy until non-alnum ch is encountered */
     str2[j++] = str[(*nch)++];
  str2[j] = '\0';
  return 1;
}
/**********************************************************************/
int span_comma(line,nch)
/**********************************************************************/
/*
   moves past all spaces and a comma
                                                                      */
char *line;
int *nch;
{
  char ch;
  if(!span_white(line,nch)) return 0;
  ch = line[*nch];
  if(ch != ',') return 1;
  ++(*nch);
  if(!span_white(line,nch)) return 0;
  return 1;
}

/**********************************************************************/
int span_white(str,nch)
/**********************************************************************/
char *str;
int *nch;
/*
   starting at nch, looks for first nonwhite character.  positions
   nch there.
   returns 1 -- found a nonblank
           0 -- hit eol
                                                                      */
{
  while(str[*nch] != '\0')
    if(isspace(str[*nch]) || iscntrl(str[*nch]))
          ++(*nch);
    else
          return 1;
  return 0;
}
/***************************************************************/
void convert_lc(str)
/***************************************************************/
char *str;
{
   int j;
   static char uc_a = 'A';
   static char uc_z = 'Z';
   static int offset = (int)('a' - 'A'); 

   j = 0;
   while(str[j] != '\0')
     {if(uc_a <= str[j] && str[j] <= uc_z) str[j] = str[j] + (char) offset;
      ++j;
     }
   return;
}
