#include <stdio.h>
#include <ctype.h>
#include "metastr.h"
#define EQU 1
#define END 2
#define STOP 3
#define CONST 4
#define ORG 5
#define WRONG 6

extern int curloc;
extern int srclines;
extern INSTR_FORMAT format[20];
extern OPCODE_TABLE ot;
extern PUNCT_TABLE pt;
extern LEVEL2_REGS mac;
extern SVP symtable[500];
extern int nsymtable;
extern int *objcode;         /* store object code here         */

/***************************************************************/
void pass_two(fp)
/***************************************************************/
FILE *fp;
/*
  second pass of two-pass assembler. Generates code. 
                                                               */
{
  char line[81], label[20], ae[60];
  int nch, itype,builtin,foundlabel,value,opvalue;
  void proc2_label(), proc2_opcode(), proc2_remainder(); 
  FIELD *p;

  objcode = (int *) calloc (curloc, sizeof(int));
  curloc = 0;
  srclines = 0;

getline:
  if(feof(fp)) return;
  fgets(line,81,fp);
  convert_lc(line);
  ++srclines;
/*
   comment?
                */
  if(!strncmp(line,";",1)) goto getline;
  nch = 0;
  proc2_label(line,&nch,label,&foundlabel);
  proc2_opcode(line,&nch ,&itype,&builtin,&value);
  if(!builtin)
      p = format[itype].f;
/*
   special processing for fixed assembler opcode (STOP) and
   directives (END, EQU)
                                                           */
  if(builtin)
   switch(builtin)
    {case EQU:  if(!foundlabel)
                    fatal_error(" must specify a label when using 'equ' ");
                goto getline;
     case END:  return;
     case STOP: setbit(objcode,curloc,0,15,0x0ffff); 
                ++curloc;
	        goto getline;
     case CONST:if(!get_ae(line,&nch,ae))
                  error(" illegal operand in 'const' directive");
	        else
	          {opvalue = evalae(ae);
		   setbit(objcode,curloc,0,15,opvalue);
                  }
                ++curloc;
	        goto getline;
     case ORG:  if(!get_ae(line,&nch,ae))
	          error("illegal operand in 'org' directive");
	        else
	          {value = evalae(ae);
                   curloc = value;
                  }  
     case WRONG:goto getline;
    }
  else
/*
  here to process a valid opcode
                                                           */
   {
    setbit(objcode,curloc,p->begin,p->end,value);
    proc2_remainder(line,&nch,itype);
/*
   update memory location counter
                                                           */
    curloc += format[itype].nwords;
    goto getline;
   }
}
/***************************************************************/
void proc2_label(line,nch,label,found)
/***************************************************************/
char *line;
int *nch;
char *label;
int *found;
/*
  checks to see if there is a label on this line.  If so
  returns it and sets found to 1
                                                               */
{
  char str[80];
  int status;

  if(!span_white(line,nch))
   fatal_error("blank lines illegal");
  if(*nch == 0)
   {if(an_str(line,nch,label)<= 0)
       fatal_error("nonalphanumeric label was encountered");
    *found = 1;
    if(strlen(label) > 7)
      {sprintf(str, "truncating %s to 7 characters", label);
       label[8] = '\0';
      }
    return;
   }
  *found = 0;
  return;
}
/***************************************************************/
void proc2_opcode(line,nch,itype,builtin,value)
/***************************************************************/
char *line;
int *nch,*itype;
int *builtin;
int *value;
{
  char token[50], str[81];
  int status, j;

  status = an_str(line,nch,token);
  if(status == 0)
   fatal_error("illegal leading character in opcode");
  if(status == -1)
   fatal_error("opcode missing");
/*
  found a token
                 */
  if(!strncmp(token,"equ",3))
      {*builtin = EQU;
       return;
      }
  if(!strncmp(token, "end",3))
      {*builtin = END;
       return;
      }
  if(!strncmp(token, "stop",4))
      {*builtin = STOP;
       return;
      }
  if(!strncmp(token, "org",3))
      {*builtin = ORG;
       return;
      }
  if(!strncmp(token, "const",5))
      {*builtin = CONST;
       return;
      }
/*
  token is not a builtin assembler instruction or pseduo op.
  check the opcode name table
                                                             */
  for(j=0;j<ot.n;++j)
    if(!strcmp(token,ot.op[j].sym))
      {/*
             make sure we're matching with an opcode
                                                             */
        if(ot.op[j].format >= 0)
            {*builtin = 0;
             *itype = ot.op[j].format;
             *value = ot.op[j].value;
            }
        else
            {*builtin = WRONG;
             sprintf(str,"%s is not a legal opcode",token);
             fatal_error(str);
            }
        return;
      }
  sprintf(str,"%s is not a legal opcode",token);
  fatal_error(str);
}
#define ILLEGAL -2
#define NOPUNCT 0
#define HITEOL -1
#define LEGAL 1
/***************************************************************/
void proc2_remainder(line,nch,itype)
/***************************************************************/
char *line;
int *nch;
int itype;
/*
   processes all fields after the opcode
                                                               */
{
  int j, nf, index,ktype,status, value;
  char str[50],pstr[2],msg[81];
  FIELD *p;

  nf = format[itype].nfields;
  p = format[itype].f;
  p = p->next;           /* get past the opcode field         */
  --nf;                  /* not processing the opcode field   */
  for(j=0;j<nf;++j)
   {if(p->reg || p->constant || p->key)
      {if(get2_rlk(line,nch,p,str,&value,&ktype) <= 0)
          {sprintf(msg,"illegal %s field",p->fname);
           fatal_error(msg);
          }
       setbit(objcode,curloc,p->begin,p->end,value);
      }
    if(p->punct)
      {status = get2_lpunct(line,nch,pstr,&value);
       if(status == ILLEGAL)
           {sprintf(msg,"illegal %s field",p->fname);
            fatal_error(msg);
           }
       setbit(objcode,curloc,p->begin,p->end,value);
      }
   if(j != nf-1)
       p = p->next;
   }
  return;
}
/***************************************************************/
int getsym(sym)
/***************************************************************/
/* given a symbol, finds its value in the symbol table
                                                               */
{
  int j;
  char str[80];

  for(j=0;j<nsymtable;++j)
     if(!strcmp(symtable[j].sym,sym))return symtable[j].value;
  sprintf(str,"%s not found in symbot table. contact programmer",sym);
  fatal_error(str);   
}   
/***************************************************************/
int get2_rlk(line,nch,p,ae,index,ktype)
/***************************************************************/
/*
  gets and checks any alphanumeric string (keyword, register)
  or arithmetic expression (constant)
                                                               */
char *line;
int *nch;
FIELD *p;
char *ae;
int *index;
int *ktype;
{
  if(!get_ae(line,nch,ae)) return 0;
  if(p->reg)
    {*index = isreg(ae); 
     if(*index >= 0)
       {*ktype = 1;
        *index = mac.regtup[*index].value;
        return 1;
       }
    }
  if(p->key)
    {*index = iskey(ae);
     if(*index >= 0)
       {*ktype = 2;
        *index = ot.op[*index].value;
        return 1;
       }
    }
  if(p->constant)
    {*index = evalae(ae);
     if(*index >= 0)
       {*ktype = 3;
        return 1;
       }
    }
  return 0;
} 
/***************************************************************/
int get2_lpunct(line,nch,pstr,value)
/***************************************************************/
/*
    find character in a punctuation field.  returns
           LEGAL  -- found user-defined symbol
           NOPUNCT - no punctuation.  Assuming "null"
           HITEOL -- no punctuation.  Assuming "null"
          ILLEGAL -- illegal punct or no "null" defined
                                                               */
char *line;
int *nch;
char *pstr;
int *value;
{
  int nch2, status;
  char msg[81];

  if(!span_comma(line,nch))
/*
   nothing here.  assume we have null for punctuation
                                                              */
     {*value = iskey("null");
      if(*value < 0)
        {error("missing punctuation");
         return ILLEGAL;
        }
      *value = ot.op[*value].value;
      return NOPUNCT;
     }
  nch2 = *nch;
  status = get_punct(line,&nch2,pstr);
  switch(status)
    {case ILLEGAL: sprintf(msg,"illegal character %s encountered",pstr);
                   fatal_error(msg);
     case NOPUNCT:
     case HITEOL:  *value = iskey("null");
                   if(*value < 0)
                      fatal_error("missing punctuation");
                   *value = ot.op[*value].value;
                   return NOPUNCT;
    case LEGAL:    *value = isdefpunct(pstr);
                   *value = pt.p[*value].value;
                   *nch = nch2;
                   return LEGAL;
    }
}
