
# test; M/M/1 queue--exponential ("Markov") job interarrivals,
# exponential service times, 1 server

mm1 <- function(meaninterarrv,meansrv,timelim,dbg=FALSE) {
   simlist <- newsim(dbg,mm1react)
   simlist$arrvrate <- 1 / meaninterarrv
   simlist$srvrate <- 1 / meansrv
   simlist$totjobs <- 0
   simlist$totwait <- 0.0
   simlist$queue <- newqueue(4)
   simlist$srvrbusy <- FALSE
   # defining job numbers is good practice, always invaluable during
   # debugging
   simlist$jobnum <- 0
   # event type codes: 1 for arrival, 2 for service completion
   simlist$arrvevnt <- 1
   simlist$srvevnt <- 2
   # set up first event, including info on this job's arrival time for
   # later use in finding mean wait until job done
   timeto1starrival <- rexp(1,simlist$arrvrate)
   incremjobnum(simlist)
   schedevnt(timeto1starrival,simlist$arrvevnt,simlist,
      c(timeto1starrival,simlist$jobnum))
   mainloop(simlist,timelim)
   # should print out something near 1 / (srvrate - arrvrate)
   cat("mean wait:  ")
   print(simlist$totwait / simlist$totjobs)
}

incremjobnum <- function(simlist) {
   jobnum <- simlist$jobnum + 1
   simlist$jobnum <- jobnum
   jobnum
}

# what new events are triggered by the occurrence of an old one?
mm1react <- function(evnt,simlist) {
   etype <- evnt[2]
   if (etype == simlist$arrvevnt) {  # job arrival
      # schedule next arrival
      timeofnextarrival <- simlist$currtime + rexp(1,simlist$arrvrate)
      jobnum <- incremjobnum(simlist)
      schedevnt(timeofnextarrival,simlist$arrvevnt,simlist,
         c(timeofnextarrival,jobnum))
      # start newly-arrived job or queue it
      if (!simlist$srvrbusy) {  # start job service
         simlist$srvrbusy <- TRUE
         srvduration <- rexp(1,simlist$srvrate)
         schedevnt(simlist$currtime+srvduration,simlist$srvevnt,
            simlist,evnt[3:4])
      } else {  # add to queue
         appendfcfs(simlist$queue,evnt)
      }
   } else if (etype == simlist$srvevnt) {  # job completion
      # bookkeeping
      simlist$totjobs <- simlist$totjobs + 1
      simlist$totwait <- simlist$totwait + simlist$currtime - evnt[3]
      simlist$srvrbusy <- FALSE
      # check queue for waiting jobs
      if (nrow(simlist$queue$m) > 0) {
         qhead <- delfcfs(simlist$queue)
         # start job service
         simlist$srvrbusy <- TRUE
         srvduration <- rexp(1,simlist$srvrate)
         schedevnt(simlist$currtime+srvduration,simlist$srvevnt,simlist,
            qhead[3:4])
      }
   } 
}
