\name{smoothz}
\alias{smoothz}
\alias{smoothzpred}
\alias{knnreg}
\alias{knndens}

\title{
Smoothing functions.
}

\description{

Routines for k-Nearest Neighbor density and regression estimation,
optionally using parallel computation.

}

\usage{
smoothz(z,sf,k,checkna=T,cls=NULL,nchunks=length(cls))
smoothzpred(newx,oldx,oldxregest,checkna=T,cls=NULL,nchunks=length(cls))
knnreg(data,k) 
knndens(data,k) 
}

\arguments{
   \item{z}{The data, in data frame or matrix form.}
   \item{sf}{Smoothing function, \code{knnreg} for regression or
   \code{knndens} for density estimation.}
   \item{k}{Number of nearest neighbors.}
   \item{nchunks}{Number of chunks to break the computation into.}
   \item{newx}{X-variable values in new data for which to predict Y
      values (regression case only).}
   \item{oldx}{X-variable values in the training set (regression case
      only).}
   \item{oldxregest}{Estimated regression values in the training set.}
   \item{checkna}{If TRUE, remove any row having at least one NA value.}
   \item{cls}{Cluster to use (see the \code{parallel} package) for
      parallel computation.}
   \item{data}{Data to be smoothed.}
}

\details{The smoothed values are calculated at the input data points
(needed in this form for another application).

The density estimates are not mormalized so that the total
area under the function is 1.0.

In the case of non-null \code{nchunks}, smoothing is done within-chunk
only.  The smoothed value at a point will be computed only from its
neighbors in the point's chunk.
}

\value{Vector of smoothed values, or in the case of \code{smoothzpred()},
vector of predicted Y values for \code{newx}.  
}

\author{
Norm Matloff <matloff@cs.ucdavis.edu>
}

% \keyword{
% }

% \seealso{
% }

% \examples{
% freqparcoord(baseball,5,4:6,7,cls=c2,method="extremedens",coding="color")
% }


