#include <stdio.h>
#include <unistd.h> 		//for "close" call
#include <string.h> 
#include <stdlib.h>
#include <sys/time.h> 
#include "UCTGlobal.h" 
#include "UCTInclude.h"

/* UCTInit() is called at the beginning of the user application to initialize
   UCTuplets environment. It takes the arguments that were passed to the
   user application as input parameters. */

void UCTInit(int argc, char ** argv) {
  int t1, t2;

  // assign environment variables
  strcpy(UCTTMName, argv[1]);
  UCTPortNum = atoi(argv[2]);
  UCTNodeNum = atoi(argv[3]);
  UCTNWorkNodes = (atoi(argv[4]) - 1);

  if (UCTNodeNum == 0) {
    t1 = time(NULL);
    UCTupleManager();	// start Tuple manager if we are node 0
    t2 = time(NULL);
    printf("\n\nManager Time Delta: %d\n\n", t2 - t1);
  }
  else {
    UCTConnectToTM();	// otherwise, connect to manager and call Worker()
    Worker();
    close(SD);		// worker is done, so clean up environment
  }
  delete [] HeaderBuffer;
}

/* Error() is used to report errors and terminate the program */
void Error(char * string) {
  printf ("%s\nProgram will terminate...\n", string);
  exit(0);
}













