
#include <stdio.h>
#include <stdlib.h>

/* UCTuplets sample program

   does matrix multiplication, A*X = Y, where A is nxn, and X
   and Y are nx1

   A and X will be generated within the program

   there will be a task farm in tuple space, indicating 
   the next row to be multiplied; the tuple ("next row",5), for instance,
   means to multiply row 5; a row value >= N means we are all done

*/

#include <UCTInclude.h> 

int N, /* dimension of matrix */
    *A, /* will serve as the A array after malloc() */
    *X, /* will serve as the X array after malloc() */
    Row,  /* current row to multiply */
    Debug;

void InitAX()  /* serves as a simple example; in some applications,
             A and X might come from elsewhere, including disk and 
             the tuple space */ 

{  int I,J;

   A = (int *) malloc(N*N*sizeof(int));
   X = (int *) malloc(N*sizeof(int));
   for (I = 0; I < N; I++)  {
      for (J = 0; J < N; J++)
         A[I*N+J] = I - J;
      X[I] = I;
   }
}

int Mult()

{  int J,DP = 0;

   for (J = 0; J < N; J++) DP += A[Row*N+J] * X[J];
   return DP;
}

void DoWork()

{  int DotProduct;

   while (1)  {
      in("rsp","next row",&Row);
      out("rsi","next row",Row+1); 
      if (Row >= N) break;
      DotProduct = Mult();
      out("rsii","y",Row,DotProduct);  
   }

   /* set up indirect barrier */
   out("rs","done");
}

void Worker()

{  int Value,Node,I;

   while(Debug) ;
  
   /* set up the "next row" tuple */
   if (UCTNodeNum == 1)  out("rsi","next row",0);

   /* set A and X */
   InitAX();

   /* here is where the main work is done */
   DoWork();

   /* node 1 will print the results, but need to make sure everyone 
      is done first (indirect barrier) */
   if (UCTNodeNum == 1)  {
      for (Node = 1; Node < UCTNWorkNodes; Node++)
         in("rs","done");
      for (I = 0; I < N; I++)  {
         in("rsip","y",I,&Value);
	 printf("%d\n",Value);
      }
   }

   out ("rs", "UCTEnd");  // terminate worker
}

int main(int argc,char **argv)

{  N = atoi(argv[5]);
   Debug = atoi(argv[6]);
   UCTInit(argc,argv);  
}
