//UCTFunc.c
//Writen by Michael Foster
//for ECS 158 - Programming on Parallel Architectures
//May 16, 1999

#include <UCTFunc.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include <unistd.h>
#include <errno.h>

// for SPARCs, uncomment the following line
// #include <sys/filio.h>

/////////////////GLOBAL DATA //////////////////////////////////////
///////////////////////////////////////////////////////////////////
int SD; //socket descriuptor
int runningNodes;  //number of Nodes corrently connected

//This is the tuple space
UCTuple tupleSpace[MAX_TUPLES];
int numTuples; //number of Tuples currently in Tuple space


//These constitute pending Queue
PendingTuple pendQ[MAX_TUPLES];
int numPending =0; //number of requests in the pending Queue


////////////////////////////////////////
////////////// writeAll ////////////////
////////////////////////////////////////
int writeAll(int fd, char *b, int len){
   int totcount = 0;
   int count = 0;

   while (totcount < len){
      count = write(fd, (b+totcount), (len-totcount));
      if (count > 0) totcount += count;
      if (count == -1) return(-1);
   }
   return(totcount);
}

////////////////////////////////////////
////////////// readAll /////////////////
////////////////////////////////////////
int readAll(int fd, char* b, int len){
   int totcount = 0;
   int count = 0;
   while (totcount < len){
      count = read(fd, (b+totcount), (len-totcount));
      if (count > 0) totcount += count;
      if (count == -1) return(-1);
   }
   return(totcount);
}

////////////////////////////////////////
////////////// recv_msg ////////////////
////////////////////////////////////////
//This will  extract the information from the header message and then 
//recieve the tuple data from  fd, and place it into type, comp, and data.
//type,comp, and data should be valid pointers set to NULL or a malloc type return
int recv_msg(char **type, int **comp, char **data, char *header, int fd){
   int j,len, size, b_ptr=0;
   char buffer[BUFF_SIZE];

   memset(buffer,0,BUFF_SIZE);
   //move message from buffer into local space
   memcpy(&size, header+MSG_DATA_SIZE, MSG_FIELD_SIZE);
   memcpy(&len, header+MSG_NUM_COMP, MSG_FIELD_SIZE);

   //read in tuple information
   readAll(fd,buffer,size);

   //move tupil information into local space
   *type=realloc(*type, len+1);
   memcpy(*type, buffer+b_ptr, len);
   (*type)[len]=0; //add terminating '\0'
   b_ptr += len;
   *comp = realloc(*comp, len*COMP_SIZE);
   memcpy(*comp, buffer+b_ptr, len*COMP_SIZE);
   b_ptr += len*COMP_SIZE;
   if ((size-b_ptr) > 0){  //if there is data to be copied
      *data = realloc(*data, size-b_ptr);
      memcpy(*data, buffer+b_ptr, size-b_ptr);
   }
   
   return(header[0]);
}

////////////////////////////////////////
////////////// send_msg ////////////////
////////////////////////////////////////
//send tuple data to fd.  The data should come in just like it would from a tupil.
//Each string and array type component will contain the starting point in the data
//array
//This will return the value of the writeAll() function call(number of bytes sent)
int send_msg(int fd, char header, char* type, int *comp, char* data){
   char buffer[BUFF_SIZE];
   int size, len, b_ptr=0, datasize,i;
   
   //calc the number of components
   len = strlen(type); 

   //calculate size of data array
   datasize=0;
   for (i=0; i<len; i++){
      switch(type[i]){
      case('s'):
         datasize += strlen(data+comp[i])+1; //add one for the null character
         break;
      case('I'):
      case('F'):
         if (type[i-1] != 'p'){
            datasize += comp[i-1]*COMP_SIZE;
         }
         break;
      }
   }

   //calc size of the tuple information
   size = (len) + (len*COMP_SIZE) + datasize; 
   
   //create the header
   buffer[0] = header;
   memcpy(buffer+MSG_DATA_SIZE, &size, MSG_FIELD_SIZE);
   memcpy(buffer+MSG_NUM_COMP, &len, MSG_FIELD_SIZE);
   
   //add the data to the end of the buffer 
   b_ptr = MSG_SIZE;
   memcpy(buffer+b_ptr, type, len);
   b_ptr += len;
   memcpy(buffer+b_ptr, comp, len*COMP_SIZE);
   b_ptr += len*COMP_SIZE;
   memcpy(buffer+b_ptr, data, datasize);

   //write out all of the information
   return(writeAll(fd, buffer, MSG_SIZE+size));
}

////////////////////////////////////////
////////////// process_msg /////////////
////////////////////////////////////////
int process_msg(char msg_header, char *type, int *comp, char *data, int fd){
   UCTuple t;
   char buffer[MSG_SIZE];
   char *newData=NULL;
   char header;
   int j;

   switch(msg_header){
   case(IN)://remove and return a tuple
      if ((j=find(type, comp, data)) != -1){
         UCTremove(&t, j);
         getComps(t, &type, &comp, &newData); //data can be reallocated
         destroyTuple(&t);
         send_msg(fd, ANS, type, comp, newData);
      }
      else{
         createTuple(&t, type, comp, data);
         if (addToPend(msg_header, fd, t) == -1){
            printf("ERROR: Overflow on pending buffer");
            return(-1);
         }
         destroyTuple(&t);
      }
      break;
   case(READ)://return information from tupil space
      if ((j=find(type, comp, data)) != -1){
         UCTremove(&t,j);
         getComps(t, &type, &comp, &newData);
         send_msg(fd,ANS, type, comp, newData);
         if (UCTinsert(t) == -1){
            printf("Overflow on tuple space\n");
            return(-1);
         }
         destroyTuple(&t);
      }
      else{
         createTuple(&t,type,comp,data);
         if (addToPend(msg_header, fd, t) == -1){
            printf("ERROR: Overflow pending queue");
            return(-1);
         }
         destroyTuple(&t);
      }
      break;
   case(OUT): //We are inserting the tupil into the tupil space
      //send ANS message to tell node its request was recieved
      buffer[0] = ANS;
      writeAll(fd,buffer,MSG_SIZE);

      if ((strcmp(data,"UCTEnd")==0)&&(strcmp(type,"s")==0))
         runningNodes--; //check to see if the node is exiting 
      
      //check pending queue
      createTuple(&t,type,comp,data);
      for (j=0;j<numPending;j++){
         if(UCTmatch(t,pendQ[j].tuple.type, pendQ[j].tuple.component, pendQ[j].tuple.data)){
            send_msg(pendQ[j].ReqD,ANS, t.type, t.component, t.data);
            header = pendQ[j].request;
            //remove from pending Queue
            destroyTuple(&(pendQ[j].tuple));
            numPending--;
            if (j!=numPending){//if bottom tuple removed don't move an empty tuple
               pendQ[j].request = pendQ[numPending].request;
               pendQ[j].ReqD = pendQ[numPending].ReqD;
               copyTuple(&(pendQ[j].tuple), pendQ[numPending].tuple);
               destroyTuple(&(pendQ[numPending].tuple));
            }
            if (header == IN){
               j=numPending+1; //get out of the for loop
            }
         }
      }
      if (header != IN){ //not pending so complete operation
         if (UCTinsert(t) == -1){
            printf("Overflow on tuple space\n");
            return(-1);
         }
      }
      destroyTuple(&t);
      break;
   }
   return(0);
}

////////////////////////////////////////
////////////// addToPend ///////////////
////////////////////////////////////////
//insert tuple at end of queue
int addToPend(char r, int fd, UCTuple t){
   if (numPending == MAX_TUPLES) return(-1); 
   pendQ[numPending].request = r;
   pendQ[numPending].ReqD = fd;
   copyTuple(&(pendQ[numPending].tuple),t);
   numPending++;
   return(0);
}

////////////////////////////////////////
////////// connectToNodes //////////////
////////////////////////////////////////
int connectToNodes(int *ReqD){
   struct sockaddr_in bindInfo;
   int i, Flag =1; //count and indesx vars

   //Open Socket
   if ((SD = socket(AF_INET,SOCK_STREAM,0)) == -1){
      printf("connectToNodes:Error opening Socket\n");
      return(-1);
   }

   //setup Bind structure
   bindInfo.sin_family = AF_INET;
   bindInfo.sin_port = UCTPortNum;
   bindInfo.sin_addr.s_addr=INADDR_ANY;
   
   //bind and listen to socket
   if (bind(SD,&bindInfo, sizeof(bindInfo)) == -1){
      printf("connectToNodes: Error binding socket\n");
      return(-1);
   }

   //set up request queue on socket
   if (listen(SD, REQ_BUFF_SIZE) == -1){
      printf("connectToNodes: Error listening to socket\n");
      return(-1);
   }
   
   //Connect to all nodes
   runningNodes=0;
   i=0;
   while(i<UCTNWorkNodes){ //Wait for everyone to connect
      ReqD[i] = accept(SD,0,0); //socket is blocking, this will wait
      if(ReqD[i] >0){
         //Make sure these are Non-Blocking
         if (ioctl(ReqD[i],FIONBIO,&Flag) == -1){
            printf("connectToNodes: Failed call to ioctl()\n");
            return(-1);
         }
         i++;
         runningNodes++;
      }
   }
}

////////////////////////////////////////
////////// connectToMgr ////////////////
////////////////////////////////////////
int ConnectToMgr(void){
   struct sockaddr_in Addr;
   struct hostent *Hostptr;
   int e;

   //open socket
   if ((SD = socket(AF_INET,SOCK_STREAM,0)) == -1){
      printf("Manager:Error opening Socket\n");
      return(-1);
   }

   //setup address structure
   Addr.sin_family=AF_INET;
   Addr.sin_port = UCTPortNum;
   if((Hostptr = gethostbyname(UCTTMName)) == NULL){
      printf("Error getting host address\n");
      return (-1);
   }
   memcpy(&Addr.sin_addr.s_addr, Hostptr->h_addr_list[0],Hostptr->h_length);
   //connect to server
   while(connect(SD,(struct sockaddr *) &Addr, sizeof(Addr)) < 0){
      //printf("trying to connect on socket %d: %s\n",SD,sys_errlist[errno]);
      //reopen socket and retry connect
      close(SD);
      if ((SD = socket(AF_INET,SOCK_STREAM,0)) == -1){
         printf("Manager:Error opening Socket\n");
         return(-1);
      }
   }
   //call user function
   Worker();
   //Tell manager we are done
   out("s", "UCTEnd");
   return(0);
}


////////////////////////////////////////
////////// UCTupleManager //////////////
////////////////////////////////////////
int UCTupleManager(void){
   int ReqD[UCTNWorkNodes]; //Request Descriptor Id's
   char buffer[MSG_SIZE]; //Message Buffer
   int i, j, k,count; //count and index vars

   char *type=NULL; //the type string of the tuple
   int *comp=NULL;  //The components of the current tuple
   char *data=NULL;
   char msg_header;
   UCTuple t;

   connectToNodes(ReqD);   
   while(1){//Loop waiting for requests
      for (i=0;i<UCTNWorkNodes;i++){ //do a round robin polling all nodes
         memset(buffer,0,MSG_SIZE); //reset the buffer
         count=read(ReqD[i],buffer,MSG_SIZE);
         if (count > 0){//if something to read
            //Make sure we get the whole message
            readAll(ReqD[i],(buffer+count), MSG_SIZE-count);
            
            //Get complete message and copy it to local space
            msg_header = recv_msg(&type, &comp, &data, buffer, ReqD[i]);
            process_msg(msg_header, type, comp, data, ReqD[i]);
            if (runningNodes == 0) {
               cleanUp();
               return(0);
            }
         }//end if (count>0)
      }
   }
   return(0);
}

/////////////// Tuple Space Functions //////////////////////////////////
///////////////////////////////////////////////////////////////

////////////////////////////////////////
////////// UCTInsert ///////////////////
////////////////////////////////////////
int UCTinsert(UCTuple t){
   if (numTuples == MAX_TUPLES) return(-1);
   copyTuple(&tupleSpace[numTuples],t);
   numTuples++;
   return(numTuples-1); //return the index of the tupil
}

////////////////////////////////////////
////////// UCTRemove ///////////////////
////////////////////////////////////////
int UCTremove(UCTuple *t, int i){
   
   if (i>=numTuples) return(-1); //if error retrn emptty tuple
   copyTuple(t,tupleSpace[i]);
   destroyTuple(&tupleSpace[i]);
   numTuples--;
   if(i != numTuples){ //if bottom tuple removed don't move an empty tuple
      copyTuple(&tupleSpace[i], tupleSpace[numTuples]);
      destroyTuple(&tupleSpace[numTuples]);
   }
   return(0);
}

////////////////////////////////////////
////////////// find ////////////////////
////////////////////////////////////////
int find(char *m, int* c, char *d){
   int i;
   for (i=0;i<numTuples;i++){
      if(UCTmatch(tupleSpace[i],m,c,d)) return(i);
   }
   return(-1);
}

////////////////////////////////////////
////////////// cleanUp /////////////////
////////////////////////////////////////
void cleanUp(void){
   int i;

   for (i=0;i<numPending;i++){
      destroyTuple(&(pendQ[i].tuple));
   }
   for (i=0;i<numTuples;i++){
      destroyTuple(&(tupleSpace[i]));
   }
}

////////////////////////////////////////
////////////// get_args ////////////////
////////////////////////////////////////
//returns data size
int get_args(va_list args, char *type, int **comp, char **data){
   char *s;
   int i, *I;
   float f, *F;
   int size= strlen(type);
   int datasize=0, d_ptr=0;

   for (i=0;i<size;i++){
      switch (type[i]){
      case('s'):
         s=va_arg(args,char*);
         datasize += strlen(s)+1;
         *data=realloc(*data, datasize);
         strcpy((*data)+d_ptr, s);
         (*comp)[i] = d_ptr;
         d_ptr = datasize;
         break;
      case('i'):
         (*comp)[i]=va_arg(args,int);
         break;
      case('f'):
         f=va_arg(args,double); //parameter passing convention says floats take up two words in parameter list 
         memcpy(&(*comp)[i],&f, COMP_SIZE);
         break;
      case('p'):
         (*comp)[i]=(int)va_arg(args,int*);
         break;
      case('I'):
         if (type[i-1] != 'p'){
            I=va_arg(args,int*);
            datasize+=(*comp)[i-1]*COMP_SIZE;
            *data=realloc(*data,datasize);
            memcpy((*data)+d_ptr,(char*)I,(*comp)[i-1]*COMP_SIZE);
            (*comp)[i]=d_ptr;
            d_ptr=datasize;
         }
         else{
            I=va_arg(args,int*);
            memcpy(&(*comp)[i],&I, COMP_SIZE);
         }
         break;
      case('F'):
         if (type[i-1] != 'p'){
            F=va_arg(args,float*);
            datasize+=(*comp)[i-1]*COMP_SIZE;
            *data=realloc(*data,datasize);
            memcpy((*data)+d_ptr,(char*)F,(*comp)[i-1]*COMP_SIZE);
            (*comp)[i]=d_ptr;
            d_ptr=datasize;
         }
         else{
            F=va_arg(args,float*);
            memcpy(&(*comp)[i],&F, COMP_SIZE);
         }
         break;
      }
   }
   va_end(args);
   return(datasize);
}



