//UCTFunc.c
//Writen by Michael Foster
//for ECS 158 - Programming on Parallel Architectures
//May 16, 1999

#include <UCTuple.h>
#include <stdarg.h>

//The initial messages sent to and from the manager are 
//defined by the following fields
#define MSG_TAG            0                                   //location of tag field
#define MSG_TAG_LEN        1                                   //length of tag field
#define MSG_DATA_SIZE      (MSG_TAG + MSG_TAG_LEN)             //size of data message
#define MSG_FIELD_SIZE     sizeof(int)                         //size of data size field
#define MSG_NUM_COMP       (MSG_DATA_SIZE + MSG_FIELD_SIZE)    //number of components in tuple
#define MSG_SIZE           (MSG_TAG_LEN + (2 * MSG_FIELD_SIZE))//size of header message

//These are the valid Message tags:
#define IN                 1  //Making a in call to manager
#define OUT                2  //Making an out call to manager
#define READ               3  //Making a read call to manager
#define ACK                5  //Manager/Node wants next part of message
#define ANS                6  //Manager returns answer

//This is a pending request element.  When a request is made to the manager and the 
//tuple does not exist the tuple and other pertinent information is stored in an array of
//these structuers
typedef struct PTStruct{
   int ReqD;      //the requesting file descriptor
   char request;  //the type of request
   UCTuple tuple; //information requested.  Not like a normal tuple, but fits in the same struct.
}PendingTuple;

//////////////Functions for manipulating the tuple space////////////////////////
//put tuple in tuple space
int UCTinsert(UCTuple t);  

//remove ith tuple from tupil space
int UCTremove(UCTuple *t, int i);  
   
//find a tuple in the tuple space
int find(char *m, int* c, char *d);

////////INTERNAL LIBRARY FUNCTIONS//////////////
////////////////////////////////////////////////

//Called by node 0. This will manage the tuple space
int UCTupleManager(void);

//Called by all nodes but 0. this will connect to the tuple manager
int ConnectToMgr(void);

//THis fuction is called from within the tuple manager.  It waits for all
//the nodes to connect to it ad returns there file dsecritors in the ReqD array.
int connectToNodes(int *ReqD);

//Thse function are an extension of the system calls read and write.  
//They will make sure len bytes before returning
int readAll(int fd, char* b, int len);
int writeAll(int fd, char* b, int len);

//THis will recieve the data message from fd.  THe header message should alread
//be recieved and palced in buffer.  This will then parse the data message and 
//place the apropriate parts in type, comp, and data. 
int recv_msg(char** type, int **comp, char **data, char *buffer, int fd);

//This will send a message to the file descriptor fd.  The header byte will
//be what is in header, and the data will be type, comp, and data put into 
//one package
int send_msg(int fd, char header, char* type, int *comp, char* data);

//This is the body of the tuple manager. Once a request is recieved this fucntion
//will take the apropriate action with that message.
int process_msg(char msg_header, char *type, int *comp, char *data, int fd);

//this a fucntin that simply adds a request to the pending Queue.
int addToPend(char r, int fd, UCTuple t);

//This simply destroys the tuple space and pending Queue before exiting the manager
void cleanUp(void);

//this function is used in the in out and read calls.  It is used to parse the variable
//length arguments into the data structures used to store the tuples.
int get_args(va_list args, char *type, int **comp, char **data);