

// JSim sample program:  Stop-and-Wait protocol

public class Frame extends JSElt  

{
   int FrameNumber;
   float StartTime;  // time at which this frame is first sent
   int NTries;  // number of attempts at sending this frame so far
   boolean Trashed;  // true means corrupted

   // constructor
   Frame()

   { ; }

   public void JSPrintElt()

   {  super.JSPrintElt();
      System.out.println("  frame "+this.FrameNumber+":  number of tries = "
         +this.NTries+", trashed = "+this.Trashed);
   }

   public void JSEvntHandler()  // application-specific, overriding
                                // JSElt's version; required

   {  if (JSName.equals("arrive at B"))
         DoArrivalAtB();
      else if (JSName.equals("done with delay"))
         DoDelayDone();
      else if (JSName.equals("arrive back at A"))
         DoArrivalBackToA();
      else JSEvntPanic();
   }

   // send the frame and set the timer; New = true means that this is
   // the first time we are tyring to xmit this frame

   public void SendFrame(boolean New)

   {  JSName = "arrive at B";
      JSEvntTime = JSSim.JSSimTime + 1 + StopAndWait.Alpha;
      if (New)  {
         FrameNumber = StopAndWait.NextFrameToBeCreated++;
         StartTime = JSSim.JSSimTime;
         NTries = 1;
      }
      else NTries++;
      Trashed = false;
      JSInsertInEvntList();
      // set up the paired timeout
      StopAndWait.TmOt.JSEvntTime = JSSim.JSSimTime + 
         StopAndWait.TimeoutTime;
      StopAndWait.TmOt.JSName = "timeout";
      StopAndWait.TmOt.JSInsertInEvntList(); 
      // pair them together to enable one to cancel the other
      JSPartnerEltNumber = StopAndWait.TmOt.JSEltNumber;
      StopAndWait.TmOt.JSPartnerEltNumber = JSEltNumber;
   }

   public void DoArrivalAtB()

   {  JSName = "done with delay";
      JSEvntTime = JSSim.JSSimTime + JSSim.JSExpon(StopAndWait.MeanDelay);
      JSInsertInEvntList();
   }

   public void DoDelayDone()

   {  Trashed = (JSSim.JSRnd() < StopAndWait.P);
      JSName = "arrive back at A";
      JSEvntTime = JSSim.JSSimTime + StopAndWait.Alpha;
      JSInsertInEvntList();
   }

   public void DoArrivalBackToA()

   {  // we beat the timeout, so cancel it
      JSElt.JSCancel(JSPartnerEltNumber);
      if (Trashed)  
         SendFrame(false);  // failed, try sending again
      else  {
         // succeeded
         // need to do some bookkeeping 
         StopAndWait.TotFrames++;
         StopAndWait.TotWait += JSSim.JSSimTime - StartTime;
         StopAndWait.TotTries += NTries;
         // done, so send the next frame
         SendFrame(true);  
      }
   }
 
   public void DoTimeout()

   {  // timed out, so cancel the scheduled arrival of this frame
      JSElt.JSCancel(JSPartnerEltNumber);
      SendFrame(false);  // try sending it again
   }

}

