

// JSim sample program:  M/M/1 queue, paired with MM1.java

// this class represents one job to be done by the machine; each arrival
// produces one of these classes

public class Job extends JSElt  

{
   float ArrivalTime;  // time this job arrived

   // constructor
   Job() 

   { JSName = "arrive"; } 

   public void JSPrintElt() 

   {  super.JSPrintElt();
      System.out.println("  arrival was at "+ArrivalTime);
   }

   public void JSEvntHandler()

   {  if (JSName.equals("arrive"))
         DoArrival();
      else
         DoDone();
   }

   public void DoArrival()

   {  float Tmp;

      JSName = "done with service";
      JSServiceTime = JSSim.JSExpon(MM1.MeanServe);
      // try to serve, else add to machine queue
      if (!MM1.Machine.JSBusy)  {
         MM1.Machine.JSStartServe(this);
      }
      else MM1.Machine.JSAppendToFclQ();

      // schedule the next arrival
      Tmp = JSSim.JSExpon(MM1.MeanArrive); 
      Tmp += JSSim.JSSimTime;
      Job TmpEltPtr = new Job();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInEvntList();
   }

   // event handler:  case "done with service"
   public void DoDone() 

   {  // process the job which just finished 
      MM1.TotJobs++;
      Job TmpAE = (Job) JSSim.JSCurrEvnt;
      MM1.TotWait += JSSim.JSSimTime - TmpAE.ArrivalTime;
      // bookkeeping, plus a check of machine's queue
      MM1.Machine.JSDoneServe();
      return;
   }

}

