

// JSim sample program:  M/M/1 queue; this class represents the
// breakdown/repair process of the machine

public class UpDown extends JSElt  

{  // constructor
   UpDown() 

   {  JSName = "break down"; // alternates with "repair"
   }

   public void JSEvntHandler() 

   {  if (JSName.equals("break down")) 
         DoBreak(); 
      else if (JSName.equals("done with repair")) 
         DoRepair();
      else JSEvntPanic();
   }

   public void DoBreak() 

   {  // place the currently-executing job, if any, back into the queue
      if (Break.Mchn.JSBusy)  {
         Break.NInterrupted++;
         Break.Mchn.JSBusy = false;
         JSElt.JSCancel(Break.Mchn.JSCurrJob.JSEltNumber);
         Break.Mchn.JSCurrJob.JSEvntTime = (float) 0.0;
         // stuff this job back into the queue
         Break.Mchn.JSCurrJob.JSNext = Break.Mchn.JSFclQHd;
         Break.Mchn.JSFclQHd = Break.Mchn.JSCurrJob;
         if (Break.Mchn.JSNQ == 0) 
            Break.Mchn.JSFclQTl = Break.Mchn.JSFclQHd;
         Break.Mchn.JSCurrJob = null;
         Break.Mchn.JSNQ++;
         if (JSSim.JSDebug) System.out.println("job interrupted, JSNQ now "
            +Break.Mchn.JSNQ);
      }
      else  {
         if (JSSim.JSDebug) 
            System.out.println("breakdown but no job in service");
      }
      // record machine as down, and schedule repair
      Break.Mchn.JSBusy = false;
      Break.Mchn.Up = false;
      JSSim.JSCurrEvnt.JSName = "done with repair";
      JSSim.JSCurrEvnt.JSEvntTime = 
         JSSim.JSSimTime + JSSim.JSExpon(Break.MeanDownTime);
      JSInsertInEvntList();
   }

   public void DoRepair() 

   {  // record the machine as up, start job if queue nonempty
      // (JSDoneServe() actually works for this), and schedule the 
      // next down time
      if (JSSim.JSDebug)  {
         if (Break.Mchn.JSNQ == 0)
            System.out.println("repair done, but no jobs waiting in queue");
         else
            System.out.println("and "+Break.Mchn.JSNQ+
               " jobs waiting in queue");
      }
      Break.Mchn.Up = true;
      Break.Mchn.JSDoneServe();
      JSSim.JSCurrEvnt.JSName = "break down";
      JSSim.JSCurrEvnt.JSEvntTime = 
         JSSim.JSSimTime + JSSim.JSExpon(Break.MeanUpTime);
      JSInsertInEvntList();
   }

}

