

// JSim sample program:  M/M/1 queue; paired with Job.java, Machine.java and
// UpDown.java.

// test case:
//
// % java Break 1000000 0 99999 1 0.5 5.0 0.2 
// mean wait = 1.658803
// mean number of interruptions per job = 0.11244313

// In this version, the machine occasionally breaks down.  When it does,
// the job currently being served loses "credit" for all work done so
// far, and must be started from scratch when the machine comes back up
// again.  The machine ages even when not serving any job.

public class Break 

{  static int TotJobs = 0,  // number of jobs done so far
              NInterrupted = 0;  // number of jobs whose service has
                                 // been interrupted so far
   static float TotWait = (float) 0.0;  // total wait for those jobs
   static float MeanArrive,  // mean time between arrivals
                MeanServe,  // mean service time
                MeanUpTime,  // mean time to breakdown
                MeanDownTime;  // mean time to repair

   public static Machine Mchn;  

   public static void main(String[] Argv) 

   {  float Tmp;

      JSSim.JSInit(Argv);  // required

      // get application-specific command-line arguments
      MeanArrive = Float.parseFloat(Argv[3]);
      MeanServe = Float.parseFloat(Argv[4]);
      MeanUpTime = Float.parseFloat(Argv[5]);
      MeanDownTime = Float.parseFloat(Argv[6]);

      Mchn = new Machine();

      // "prime" the system:  set up first arrival and first breakdown
      Tmp = JSSim.JSExpon(MeanArrive);
      Job TmpEltPtr = new Job();
      TmpEltPtr.JSEvntTime = Tmp;
      TmpEltPtr.ArrivalTime = Tmp;
      TmpEltPtr.JSInsertInEvntList();  
      Tmp = JSSim.JSExpon(MeanUpTime);
      UpDown UD = new UpDown();
      UD.JSEvntTime = Tmp;
      UD.JSInsertInEvntList();  

      // now start the simulation; required call
      JSSim.JSMainLoop(Argv);
   
      // simulation done; print out results
      System.out.println("mean wait = "+TotWait/TotJobs); 
      System.out.println("mean number of interruptions per job = "
        + (float) NInterrupted/TotJobs); 
   }

}


