     1	%{
     2	#include "c.h"
     3	#define NODEPTR_TYPE Node
     4	#define OP_LABEL(p) ((p)->op)
     5	#define LEFT_CHILD(p) ((p)->kids[0])
     6	#define RIGHT_CHILD(p) ((p)->kids[1])
     7	#define STATE_LABEL(p) ((p)->x.state)
     8	static void address     ARGS((Symbol, Symbol, int));
     9	static void blkfetch    ARGS((int, int, int, int));
    10	static void blkloop     ARGS((int, int, int, int, int, int[]));
    11	static void blkstore    ARGS((int, int, int, int));
    12	static void defaddress  ARGS((Symbol));
    13	static void defconst    ARGS((int, Value));
    14	static void defstring   ARGS((int, char *));
    15	static void defsymbol   ARGS((Symbol));
    16	static void doarg       ARGS((Node));
    17	static void emit2       ARGS((Node));
    18	static void export      ARGS((Symbol));
    19	static void clobber     ARGS((Node));
    20	static void function    ARGS((Symbol, Symbol [], Symbol [], int));
    21	static void global      ARGS((Symbol));
    22	static void import      ARGS((Symbol));
    23	static void local       ARGS((Symbol));
    24	static void progbeg     ARGS((int, char **));
    25	static void progend     ARGS((void));
    26	static void segment     ARGS((int));
    27	static void space       ARGS((int));
    28	static void target      ARGS((Node));
    29	static int imm ARGS((Node));
    30	static void rename ARGS((void));
    31	static void defsymbol2 ARGS((Symbol));
    32	static void global2 ARGS((Symbol));
    33	static void segment2 ARGS((int));
       
    34	static Symbol greg[32];
    35	static Symbol *oreg = &greg[8], *ireg = &greg[24];
    36	static Symbol freg[32], freg2[32];
       
    37	static int retstruct;
       
    38	static int pflag = 0;
       
    39	static int cseg;
       
    40	%}
    41	%start stmt
    42	%term ADDD=306 ADDF=305 ADDI=309 ADDP=311 ADDU=310
    43	%term ADDRFP=279
    44	%term ADDRGP=263
    45	%term ADDRLP=295
    46	%term ARGB=41 ARGD=34 ARGF=33 ARGI=37 ARGP=39
    47	%term ASGNB=57 ASGNC=51 ASGND=50 ASGNF=49 ASGNI=53 ASGNP=55 ASGNS=52
    48	%term BANDU=390
    49	%term BCOMU=406
    50	%term BORU=422
    51	%term BXORU=438
    52	%term CALLB=217 CALLD=210 CALLF=209 CALLI=213 CALLV=216
    53	%term CNSTC=19 CNSTD=18 CNSTF=17 CNSTI=21 CNSTP=23 CNSTS=20 CNSTU=22
    54	%term CVCI=85 CVCU=86
    55	%term CVDF=97 CVDI=101
    56	%term CVFD=114
    57	%term CVIC=131 CVID=130 CVIS=132 CVIU=134
    58	%term CVPU=150
    59	%term CVSI=165 CVSU=166
    60	%term CVUC=179 CVUI=181 CVUP=183 CVUS=180
    61	%term DIVD=450 DIVF=449 DIVI=453 DIVU=454
    62	%term EQD=482 EQF=481 EQI=485
    63	%term GED=498 GEF=497 GEI=501 GEU=502
    64	%term GTD=514 GTF=513 GTI=517 GTU=518
    65	%term INDIRB=73 INDIRC=67 INDIRD=66 INDIRF=65 INDIRI=69 INDIRP=71 INDIRS=68
    66	%term JUMPV=584
    67	%term LABELV=600
    68	%term LED=530 LEF=529 LEI=533 LEU=534
    69	%term LOADB=233 LOADC=227 LOADD=226 LOADF=225 LOADI=229 LOADP=231 LOADS=228 LOADU=230
    70	%term LSHI=341 LSHU=342
    71	%term LTD=546 LTF=545 LTI=549 LTU=550
    72	%term MODI=357 MODU=358
    73	%term MULD=466 MULF=465 MULI=469 MULU=470
    74	%term NED=562 NEF=561 NEI=565
    75	%term NEGD=194 NEGF=193 NEGI=197
    76	%term RETD=242 RETF=241 RETI=245
    77	%term RSHI=373 RSHU=374
    78	%term SUBD=322 SUBF=321 SUBI=325 SUBP=327 SUBU=326
    79	%term VREGP=615
    80	%%
    81	reg:  INDIRC(VREGP)     "# read register\n"
    82	reg:  INDIRD(VREGP)     "# read register\n"
    83	reg:  INDIRF(VREGP)     "# read register\n"
    84	reg:  INDIRI(VREGP)     "# read register\n"
    85	reg:  INDIRP(VREGP)     "# read register\n"
    86	reg:  INDIRS(VREGP)     "# read register\n"
    87	stmt: ASGNC(VREGP,reg)  "# write register\n"
    88	stmt: ASGND(VREGP,reg)  "# write register\n"
    89	stmt: ASGNF(VREGP,reg)  "# write register\n"
    90	stmt: ASGNI(VREGP,reg)  "# write register\n"
    91	stmt: ASGNP(VREGP,reg)  "# write register\n"
    92	stmt: ASGNS(VREGP,reg)  "# write register\n"
    93	con: CNSTC  "%a"
    94	con: CNSTI  "%a"
    95	con: CNSTP  "%a"
    96	con: CNSTS  "%a"
    97	con: CNSTU  "%a"
    98	stmt: reg  ""
    99	reg: CVIU(reg)  "%0"  notarget(a)
   100	reg: CVPU(reg)  "%0"  notarget(a)
   101	reg: CVUI(reg)  "%0"  notarget(a)
   102	reg: CVUP(reg)  "%0"  notarget(a)
   103	reg: ADDRGP  "set %a,%%%c\n"  1
   104	stk13: ADDRFP  "%a"                  imm(a)
   105	stk13: ADDRLP  "%a"                  imm(a)
   106	reg:   stk13   "add %0,%%fp,%%%c\n"  1
   107	stk: ADDRFP  "set %a,%%%c\n"                      2
   108	stk: ADDRLP  "set %a,%%%c\n"                      2
   109	reg: ADDRFP  "set %a,%%%c\nadd %%%c,%%fp,%%%c\n"  3
   110	reg: ADDRLP  "set %a,%%%c\nadd %%%c,%%fp,%%%c\n"  3
   111	con13: CNSTC  "%a"  imm(a)
   112	con13: CNSTI  "%a"  imm(a)
   113	con13: CNSTP  "%a"  imm(a)
   114	con13: CNSTS  "%a"  imm(a)
   115	con13: CNSTU  "%a"  imm(a)
   116	base: ADDI(reg,con13)  "%%%0+%1"
   117	base: ADDP(reg,con13)  "%%%0+%1"
   118	base: ADDU(reg,con13)  "%%%0+%1"
   119	base: reg    "%%%0"
   120	base: con13  "%0"
   121	base: stk13  "%%fp+%0"
   122	addr: base           "%0"
   123	addr: ADDI(reg,reg)  "%%%0+%%%1"
   124	addr: ADDP(reg,reg)  "%%%0+%%%1"
   125	addr: ADDU(reg,reg)  "%%%0+%%%1"
   126	addr: stk            "%%fp+%%%0"
   127	reg:  INDIRC(addr)     "ldsb [%0],%%%c\n"  1
   128	reg:  INDIRS(addr)     "ldsh [%0],%%%c\n"  1
   129	reg:  INDIRI(addr)     "ld [%0],%%%c\n"    1
   130	reg:  INDIRP(addr)     "ld [%0],%%%c\n"    1
   131	reg:  INDIRF(addr)     "ld [%0],%%f%c\n"   1
   132	stmt: ASGNC(addr,reg)  "stb %%%1,[%0]\n"   1
   133	stmt: ASGNS(addr,reg)  "sth %%%1,[%0]\n"   1
   134	stmt: ASGNI(addr,reg)  "st %%%1,[%0]\n"    1
   135	stmt: ASGNP(addr,reg)  "st %%%1,[%0]\n"    1
   136	stmt: ASGNF(addr,reg)  "st %%f%1,[%0]\n"   1
   137	addrl: ADDRLP            "%%%fp+%a"          imm(a)
       
   138	reg:   INDIRD(addrl)     "ldd [%0],%%f%c\n"  1
   139	stmt:  ASGND(addrl,reg)  "std %%f%1,[%0]\n"  1
   140	reg:  INDIRD(base)     "ld2 [%0],%%f%c\n"  2
   141	stmt: ASGND(base,reg)  "st2 %%f%1,[%0]\n"  2
   142	spill:  ADDRLP          "%a" !imm(a)
       
   143	stmt: ASGNC(spill,reg)  "set %0,%%g1\nstb %%%1,[%%fp+%%g1]\n"
   144	stmt: ASGNS(spill,reg)  "set %0,%%g1\nsth %%%1,[%%fp+%%g1]\n"
   145	stmt: ASGNI(spill,reg)  "set %0,%%g1\nst %%%1,[%%fp+%%g1]\n"
   146	stmt: ASGNP(spill,reg)  "set %0,%%g1\nst %%%1,[%%fp+%%g1]\n"
   147	stmt: ASGNF(spill,reg)  "set %0,%%g1\nst %%f%1,[%%fp+%%g1]\n"
   148	stmt: ASGND(spill,reg)  "set %0,%%g1\nstd %%f%1,[%%fp+%%g1]\n"
   149	reg: CVCI(INDIRC(addr))  "ldsb [%0],%%%c\n"  1
   150	reg: CVSI(INDIRS(addr))  "ldsh [%0],%%%c\n"  1
   151	reg: CVCU(INDIRC(addr))  "ldub [%0],%%%c\n"  1
   152	reg: CVSU(INDIRS(addr))  "lduh [%0],%%%c\n"  1
   153	reg: CVIC(reg)  "mov %%%0,%%%c\n"  move(a)
   154	reg: CVIS(reg)  "mov %%%0,%%%c\n"  move(a)
   155	reg: CVIU(reg)  "mov %%%0,%%%c\n"  move(a)
   156	reg: CVPU(reg)  "mov %%%0,%%%c\n"  move(a)
   157	reg: CVUC(reg)  "mov %%%0,%%%c\n"  move(a)
   158	reg: CVUI(reg)  "mov %%%0,%%%c\n"  move(a)
   159	reg: CVUP(reg)  "mov %%%0,%%%c\n"  move(a)
   160	reg: CVUS(reg)  "mov %%%0,%%%c\n"  move(a)
   161	reg: CVIC(reg)  "%0"  notarget(a)
   162	reg: CVIS(reg)  "%0"  notarget(a)
   163	reg: CVUC(reg)  "%0"  notarget(a)
   164	reg: CVUS(reg)  "%0"  notarget(a)
   165	reg: LOADC(reg)  "mov %%%0,%%%c\n"  move(a)
   166	reg: LOADI(reg)  "mov %%%0,%%%c\n"  move(a)
   167	reg: LOADP(reg)  "mov %%%0,%%%c\n"  move(a)
   168	reg: LOADS(reg)  "mov %%%0,%%%c\n"  move(a)
   169	reg: LOADU(reg)  "mov %%%0,%%%c\n"  move(a)
   170	reg: CNSTC  "# reg\n"  range(a, 0, 0)
   171	reg: CNSTI  "# reg\n"  range(a, 0, 0)
   172	reg: CNSTP  "# reg\n"  range(a, 0, 0)
   173	reg: CNSTS  "# reg\n"  range(a, 0, 0)
   174	reg: CNSTU  "# reg\n"  range(a, 0, 0)
   175	reg: con  "set %0,%%%c\n"  1
   176	rc: con13  "%0"
   177	rc: reg    "%%%0"
   178	reg: ADDI(reg,rc)   "add %%%0,%1,%%%c\n"  1
   179	reg: ADDP(reg,rc)   "add %%%0,%1,%%%c\n"  1
   180	reg: ADDU(reg,rc)   "add %%%0,%1,%%%c\n"  1
   181	reg: BANDU(reg,rc)  "and %%%0,%1,%%%c\n"  1
   182	reg: BORU(reg,rc)   "or %%%0,%1,%%%c\n"   1
   183	reg: BXORU(reg,rc)  "xor %%%0,%1,%%%c\n"  1
   184	reg: SUBI(reg,rc)   "sub %%%0,%1,%%%c\n"  1
   185	reg: SUBP(reg,rc)   "sub %%%0,%1,%%%c\n"  1
   186	reg: SUBU(reg,rc)   "sub %%%0,%1,%%%c\n"  1
   187	rc5: CNSTI  "%a"    range(a, 0, 31)
   188	rc5: reg    "%%%0"
   189	reg: LSHI(reg,rc5)  "sll %%%0,%1,%%%c\n"  1
   190	reg: LSHU(reg,rc5)  "sll %%%0,%1,%%%c\n"  1
   191	reg: RSHI(reg,rc5)  "sra %%%0,%1,%%%c\n"  1
   192	reg: RSHU(reg,rc5)  "srl %%%0,%1,%%%c\n"  1
   193	reg: BANDU(reg,BCOMU(rc))  "andn %%%0,%1,%%%c\n"  1
   194	reg: BORU(reg,BCOMU(rc))   "orn %%%0,%1,%%%c\n"   1
   195	reg: BXORU(reg,BCOMU(rc))  "xnor %%%0,%1,%%%c\n"  1
   196	reg: NEGI(reg)   "neg %%%0,%%%c\n"  1
   197	reg: BCOMU(reg)  "not %%%0,%%%c\n"  1
   198	reg: CVCI(reg)  "sll %%%0,24,%%%c; sra %%%c,24,%%%c\n"  2
   199	reg: CVSI(reg)  "sll %%%0,16,%%%c; sra %%%c,16,%%%c\n"  2
   200	reg: CVCU(reg)  "and %%%0,0xff,%%%c\n"                   1
   201	reg: CVSU(reg)  "set 0xffff,%%g1; and %%%0,%%g1,%%%c\n"  2
   202	addrg: ADDRGP        "%a"
   203	stmt:  JUMPV(addrg)  "ba %0; nop\n"   2
   204	stmt:  JUMPV(addr)   "jmp %0; nop\n"  2
   205	stmt:  LABELV        "%a:\n"
   206	stmt: EQI(reg,rc)  "cmp %%%0,%1; be %a; nop\n"    3
   207	stmt: GEI(reg,rc)  "cmp %%%0,%1; bge %a; nop\n"   3
   208	stmt: GEU(reg,rc)  "cmp %%%0,%1; bgeu %a; nop\n"  3
   209	stmt: GTI(reg,rc)  "cmp %%%0,%1; bg %a; nop\n"    3
   210	stmt: GTU(reg,rc)  "cmp %%%0,%1; bgu %a; nop\n"   3
   211	stmt: LEI(reg,rc)  "cmp %%%0,%1; ble %a; nop\n"   3
   212	stmt: LEU(reg,rc)  "cmp %%%0,%1; bleu %a; nop\n"  3
   213	stmt: LTI(reg,rc)  "cmp %%%0,%1; bl %a; nop\n"    3
   214	stmt: LTU(reg,rc)  "cmp %%%0,%1; blu %a; nop\n"   3
   215	stmt: NEI(reg,rc)  "cmp %%%0,%1; bne %a; nop\n"   3
   216	call: ADDRGP           "%a"
   217	call: addr             "%0"
   218	reg:  CALLD(call)      "call %0; nop\n"                2
   219	reg:  CALLF(call)      "call %0; nop\n"                2
   220	reg:  CALLI(call)      "call %0; nop\n"                2
   221	stmt: CALLV(call)      "call %0; nop\n"                2
   222	stmt: CALLB(call,reg)  "call %0; st %%%1,[%%sp+64]\n"  2
   223	stmt: RETD(reg)  "# ret\n"  1
   224	stmt: RETF(reg)  "# ret\n"  1
   225	stmt: RETI(reg)  "# ret\n"  1
   226	stmt: ARGI(reg)  "st %%%0,[%%sp+4*%c+68]\n"  1
   227	stmt: ARGP(reg)  "st %%%0,[%%sp+4*%c+68]\n"  1
   228	stmt: ARGD(reg)  "# ARGD\n"  1
   229	stmt: ARGF(reg)  "# ARGF\n"  1
       
   230	reg: DIVI(reg,reg)  "call .div,2; nop\n"   2
   231	reg: DIVU(reg,reg)  "call .udiv,2; nop\n"  2
   232	reg: MODI(reg,reg)  "call .rem,2; nop\n"   2
   233	reg: MODU(reg,reg)  "call .urem,2; nop\n"  2
   234	reg: MULI(reg,reg)  "call .mul,2; nop\n"   2
   235	reg: MULU(reg,reg)  "call .umul,2; nop\n"  2
   236	reg: ADDD(reg,reg)  "faddd %%f%0,%%f%1,%%f%c\n"  1
   237	reg: ADDF(reg,reg)  "fadds %%f%0,%%f%1,%%f%c\n"  1
   238	reg: DIVD(reg,reg)  "fdivd %%f%0,%%f%1,%%f%c\n"  1
   239	reg: DIVF(reg,reg)  "fdivs %%f%0,%%f%1,%%f%c\n"  1
   240	reg: MULD(reg,reg)  "fmuld %%f%0,%%f%1,%%f%c\n"  1
   241	reg: MULF(reg,reg)  "fmuls %%f%0,%%f%1,%%f%c\n"  1
   242	reg: SUBD(reg,reg)  "fsubd %%f%0,%%f%1,%%f%c\n"  1
   243	reg: SUBF(reg,reg)  "fsubs %%f%0,%%f%1,%%f%c\n"  1
   244	reg: NEGF(reg)   "fnegs %%f%0,%%f%c\n"  1
   245	reg: LOADF(reg)  "fmovs %%f%0,%%f%c\n"  1
   246	reg: CVDF(reg)   "fdtos %%f%0,%%f%c\n"  1
   247	reg: CVFD(reg)   "fstod %%f%0,%%f%c\n"  1
   248	reg: CVDI(reg)  "fdtoi %%f%0,%%f0; st %%f0,[%%sp+64]; ld [%%sp+64],%%%c\n"  3
       
   249	reg: CVID(reg)  "st %%%0,[%%sp+64]; ld [%%sp+64],%%f%c; fitod %%f%c,%%f%c\n"  3
       
   250	rel: EQD(reg,reg)  "fcmped %%f%0,%%f%1; nop; fbue"
   251	rel: EQF(reg,reg)  "fcmpes %%f%0,%%f%1; nop; fbue"
   252	rel: GED(reg,reg)  "fcmped %%f%0,%%f%1; nop; fbuge"
   253	rel: GEF(reg,reg)  "fcmpes %%f%0,%%f%1; nop; fbuge"
   254	rel: GTD(reg,reg)  "fcmped %%f%0,%%f%1; nop; fbug"
   255	rel: GTF(reg,reg)  "fcmpes %%f%0,%%f%1; nop; fbug"
   256	rel: LED(reg,reg)  "fcmped %%f%0,%%f%1; nop; fbule"
   257	rel: LEF(reg,reg)  "fcmpes %%f%0,%%f%1; nop; fbule"
   258	rel: LTD(reg,reg)  "fcmped %%f%0,%%f%1; nop; fbul"
   259	rel: LTF(reg,reg)  "fcmpes %%f%0,%%f%1; nop; fbul"
   260	rel: NED(reg,reg)  "fcmped %%f%0,%%f%1; nop; fbne"
   261	rel: NEF(reg,reg)  "fcmpes %%f%0,%%f%1; nop; fbne"
       
   262	stmt: rel  "%0 %a; nop\n"  4
   263	reg:  LOADD(reg)  "# LOADD\n"  2
       
   264	reg:  NEGD(reg)  "# NEGD\n"  2
       
   265	stmt:  ASGNB(reg,INDIRB(reg))  "# ASGNB\n"
       
   266	%%
   267	static void progend(){}
   268	static void progbeg(argc, argv) int argc; char *argv[]; {
   269		int i;
       
   270		{
   271			union {
   272				char c;
   273				int i;
   274			} u;
   275			u.i = 0;
   276			u.c = 1;
   277			swap = (u.i == 1) != IR->little_endian;
   278		}
   279		parseflags(argc, argv);
   280		for (i = 0; i < argc; i++)
   281			if (strcmp(argv[i], "-p") == 0 || strcmp(argv[i], "-pg") == 0)
   282				pflag = 1;
   283		for (i = 0; i < 8; i++) {
   284			greg[i +  0] = mkreg(stringf("g%d", i), i +  0, 1, IREG);
   285			greg[i +  8] = mkreg(stringf("o%d", i), i +  8, 1, IREG);
   286			greg[i + 16] = mkreg(stringf("l%d", i), i + 16, 1, IREG);
   287			greg[i + 24] = mkreg(stringf("i%d", i), i + 24, 1, IREG);
   288		}
   289		for (i = 0; i < 32; i++)
   290			freg[i]  = mkreg("%d", i, 1, FREG);
   291		for (i = 0; i < 31; i += 2)
   292			freg2[i] = mkreg("%d", i, 3, FREG);
   293		rmap[C] = rmap[S] = rmap[P] = rmap[B] = rmap[U] = rmap[I] =
   294			mkwildcard(greg);
   295		rmap[F] = mkwildcard(freg);
   296		rmap[D] = mkwildcard(freg2);
   297		tmask[IREG] = 0x3fff3e00;
   298		vmask[IREG] = 0x3ff00000;
   299		tmask[FREG]  = ~(unsigned)0;
   300		vmask[FREG]  = 0;
   301	}
   302	static void target(p) Node p; {
   303		assert(p);
   304		switch (p->op) {
   305		case CNSTC: case CNSTI: case CNSTS: case CNSTU: case CNSTP:
   306			if (range(p, 0, 0) == 0) {
   307				setreg(p, greg[0]);
   308				p->x.registered = 1;
   309			}
   310			break;
   311		case CALLD: setreg(p, freg2[0]);     break;
   312		case CALLF: setreg(p, freg[0]);      break;
   313		case CALLI:
   314		case CALLV: setreg(p, oreg[0]);      break;
   315		case RETD:  rtarget(p, 0, freg2[0]); break;
   316		case RETF:  rtarget(p, 0, freg[0]);  break;
   317		case RETI:
   318			rtarget(p, 0, ireg[0]);
   319			p->kids[0]->x.registered = 1;
   320			break;
   321		case ARGI: case ARGP:
   322			if (p->syms[RX]->u.c.v.i < 6) {
   323				rtarget(p, 0, oreg[p->syms[RX]->u.c.v.i]);
   324				p->op = LOAD+optype(p->op);
   325				setreg(p, oreg[p->syms[RX]->u.c.v.i]);
   326			}
   327			break;
   328		case DIVI: case MODI: case MULI:
   329		case DIVU: case MODU: case MULU:
   330			setreg(p, oreg[0]);
   331			rtarget(p, 0, oreg[0]);
   332			rtarget(p, 1, oreg[1]);
   333			break;
   334		}
   335	}
   336	static void clobber(p) Node p; {
   337		assert(p);
   338		switch (p->op) {
   339		case CALLB: case CALLD: case CALLF: case CALLI:
   340			spill(~(unsigned)3, FREG, p);
   341			break;
   342		case CALLV:
   343			spill(oreg[0]->x.regnode->mask, IREG, p);
   344			spill(~(unsigned)3, FREG, p);
   345			break;
   346		case ARGF:
   347			if (p->syms[2]->u.c.v.i <= 6)
   348				spill((1<<(p->syms[2]->u.c.v.i + 8)), IREG, p);
   349			break;
   350		case ARGD:
   351			if (p->syms[2]->u.c.v.i <= 5)
   352				spill((3<<(p->syms[2]->u.c.v.i + 8))&0xff00, IREG, p);
   353			break;
   354		case DIVI: case MODI: case MULI:
   355		case DIVU: case MODU: case MULU:
   356			spill(0x00003e00, IREG, p); break;
   357		}
   358	}
   359	static int imm(p) Node p; {
   360		return range(p, -4096, 4095);
   361	}
   362	static void doarg(p) Node p; {
   363		assert(p && p->syms[0] && p->op != ARG+B);
   364		p->syms[RX] = intconst(mkactual(4,
   365			p->syms[0]->u.c.v.i)/4);
   366	}
   367	static void emit2(p) Node p; {
   368		switch (p->op) {
   369		case ARGF: {
   370			int n = p->syms[RX]->u.c.v.i;
   371			print("st %%f%d,[%%sp+4*%d+68]\n",
   372				getregnum(p->x.kids[0]), n);
   373			if (n <= 5)
   374				print("ld [%%sp+4*%d+68],%%o%d\n", n, n);
   375			break;
   376		}
   377		case ARGD: {
   378			int n = p->syms[RX]->u.c.v.i;
   379			int src = getregnum(p->x.kids[0]);
   380			print("st %%f%d,[%%sp+4*%d+68]\n", src, n);
   381			print("st %%f%d,[%%sp+4*%d+68]\n", src+1, n+1);
   382			if (n <= 5)
   383				print("ld [%%sp+4*%d+68],%%o%d\n", n, n);
   384			if (n <= 4)
   385				print("ld [%%sp+4*%d+68],%%o%d\n", n+1, n+1);
   386			break;
   387		}
   388		case LOADD: {
   389			int dst = getregnum(p);
   390			int src = getregnum(p->x.kids[0]);
   391			print("fmovs %%f%d,%%f%d; ", src,   dst);
   392			print("fmovs %%f%d,%%f%d\n", src+1, dst+1);
   393			break;
   394		}
   395		case NEGD: {
   396			int dst = getregnum(p);
   397			int src = getregnum(p->x.kids[0]);
   398			print("fnegs %%f%d,%%f%d; ", src,   dst);
   399			print("fmovs %%f%d,%%f%d\n", src+1, dst+1);
   400			break;
   401		}
   402		case ASGNB: {
   403			static int tmpregs[] = { 1, 2, 3 };
   404			dalign = salign = p->syms[1]->u.c.v.i;
   405			blkcopy(getregnum(p->x.kids[0]), 0,
   406			        getregnum(p->x.kids[1]), 0,
   407			        p->syms[0]->u.c.v.i, tmpregs);
   408			break;
   409		}
   410		}
   411	}
   412	static void local(p) Symbol p; {
   413		if (retstruct) {
   414			p->x.name = stringd(4*16);
   415			p->x.offset = 4*16;
   416			retstruct = 0;
   417			return;
   418		}
   419		if (isscalar(p->type) && !p->addressed && !isfloat(p->type))
   420			p->sclass = REGISTER;
   421		if (glevel && glevel != 3) p->sclass = AUTO;	/* glevel!=3 is for Norman's debugger */
   422		if (askregvar(p, rmap[ttob(p->type)]) == 0)
   423			mkauto(p);
   424	}
   425	static void function(f, caller, callee, ncalls)
   426	Symbol f, callee[], caller[]; int ncalls; {
   427		int autos = 0, i, leaf, reg, varargs;
       
   428		for (i = 0; callee[i]; i++)
   429			;
   430		varargs = variadic(f->type)
   431			|| i > 0 && strcmp(callee[i-1]->name,
   432				"__builtin_va_alist") == 0;
   433	usedmask[0] = usedmask[1] = 0;
   434	freemask[0] = freemask[1] = ~(unsigned)0;
   435		for (i = 0; i < 8; i++)
   436			ireg[i]->x.regnode->vbl = NULL;
   437		offset = 68;
   438		maxargoffset = 24;
   439		reg = 0;
   440		for (i = 0; callee[i]; i++) {
   441			Symbol p = callee[i], q = caller[i];
   442			int size = roundup(q->type->size, 4);
   443			assert(q);
   444			if (isfloat(p->type) || reg >= 6) {
   445				p->x.offset = q->x.offset = offset;
   446				p->x.name = q->x.name = stringd(offset);
   447				p->sclass = q->sclass = AUTO;
   448				autos++;
   449			}
   450			else if (p->addressed || varargs)
   451				{
   452					p->x.offset = offset;
   453					p->x.name = stringd(p->x.offset);
   454					p->sclass = AUTO;
   455					q->sclass = REGISTER;
   456					askregvar(q, ireg[reg]);
   457					assert(q->x.regnode);
   458					autos++;
   459				}
   460			else if (glevel && glevel != 3) {
   461								p->x.offset = offset;
   462								p->x.name = stringd(p->x.offset);
   463								p->sclass = AUTO;
   464								q->sclass = REGISTER;
   465								askregvar(q, ireg[reg]);
   466								assert(q->x.regnode);
   467								autos++;
   468							}
       
   469			else {
   470				p->sclass = q->sclass = REGISTER;
   471				askregvar(p, ireg[reg]);
   472				assert(p->x.regnode);
   473				q->x.name = p->x.name;
   474			}
   475			offset += size;
   476			reg += isstruct(p->type) ? 1 : size/4;
   477		}
   478		assert(caller[i] == 0);
   479		offset = maxoffset = 0;
   480		retstruct = isstruct(freturn(f->type));
   481		gencode(caller, callee);
   482		maxargoffset = roundup(maxargoffset, 4);
   483		framesize = roundup(maxoffset + maxargoffset + 4*(16+1), 8);
   484		assert(!varargs || autos);
   485		leaf = (!ncalls
   486			&& !maxoffset && !autos
   487			&& !isstruct(freturn(f->type))
   488			&& !(usedmask[IREG]&0x00ffff01)
   489			&& !(usedmask[FREG]&~(unsigned)3)
   490			&& !pflag && !glevel);
   491		print(".align 4\n.proc 4\n%s:\n", f->x.name);
   492		if (leaf) {
   493			for (i = 0; caller[i] && callee[i]; i++) {
   494				Symbol p = caller[i], q = callee[i];
   495				if (p->sclass == REGISTER && q->sclass == REGISTER)
   496					assert(q->x.regnode),
   497					assert(q->x.regnode->set == IREG),
   498					assert(q->x.regnode->number >= 24),
   499					assert(q->x.regnode->number <= 31),
   500					p->x.name = greg[q->x.regnode->number - 16]->x.name;
   501				}
   502			rename();
   503		} else if (framesize <= 4095)
   504			print("save %%sp,%d,%%sp\n", -framesize);
   505		else
   506			print("set %d,%%g1; save %%sp,%%g1,%%sp\n", -framesize);
   507		if (varargs)
   508			for (; reg < 6; reg++)
   509				print("st %%i%d,[%%fp+%d]\n", reg, 4*reg + 68);
   510		else
   511			offset = 4*(16 + 1);
   512			reg = 0;
   513			for (i = 0; caller[i]; i++) {
   514				Symbol p = caller[i];
   515				if (isdouble(p->type) && reg <= 4) {
   516					print("st %%r%d,[%%fp+%d]\n",
   517						ireg[reg++]->x.regnode->number, offset);
   518					print("st %%r%d,[%%fp+%d]\n",
   519						ireg[reg++]->x.regnode->number, offset + 4);
   520				} else if (isfloat(p->type) && reg <= 5)
   521					print("st %%r%d,[%%fp+%d]\n",
   522						ireg[reg++]->x.regnode->number, offset);
   523				else
   524					reg++;
   525				offset += roundup(p->type->size, 4);
   526			}
   527	if (pflag) {
   528		int lab = genlabel(1);
   529		print("set L%d,%%o0; call mcount; nop\n", lab);
   530		print(".seg \"data\"\n.align 4; L%d:.word 0\n.seg \"text\"\n", lab);
   531	}
   532		emitcode();
   533		if (!leaf)
   534			print("ret; restore\n");
   535		else {
   536			rename();
   537			print("retl; nop\n");
   538		}
   539	}
   540	#define exch(x, y, t) (((t) = x), ((x) = (y)), ((y) = (t)))
       
   541	static void rename() {
   542		int i;
       
   543		for (i = 0; i < 8; i++) {
   544			char *ptmp;
   545			int itmp;
   546			if (ireg[i]->x.regnode->vbl)
   547				ireg[i]->x.regnode->vbl->x.name = oreg[i]->x.name;
   548			exch(ireg[i]->x.name, oreg[i]->x.name, ptmp);
   549			exch(ireg[i]->x.regnode->number,
   550				oreg[i]->x.regnode->number, itmp);
   551		}
   552	}
   553	static void defconst(ty, v) int ty; Value v; {
   554		switch (ty) {
   555		case C: print(".byte %d\n",   v.uc); return;
   556		case S: print(".half %d\n",   v.ss); return;
   557		case I: print(".word %d\n",   v.i ); return;
   558		case U: print(".word 0x%x\n", v.u ); return;
   559		case P: print(".word 0x%x\n", v.p ); return;
   560		case F:
   561			print(".word 0x%x\n", *(unsigned *)&v.f);
   562			return;
   563	case D: {
   564		unsigned *p = (unsigned *)&v.d;
   565		print(".word 0x%x\n.word 0x%x\n", p[swap], p[!swap]);
   566		return;
   567		}
   568		}
   569		assert(0);
   570	}
       
   571	static void defaddress(p) Symbol p; {
   572		print(".word %s\n", p->x.name);
   573	}
       
   574	static void defstring(n, str) int n; char *str; {
   575		char *s;
       
   576		for (s = str; s < str + n; s++)
   577			print(".byte %d\n", (*s)&0377);
   578	}
       
   579	static void address(q, p, n) Symbol q, p; int n; {
   580		q->x.offset = p->x.offset + n;
   581		if (p->scope == GLOBAL || p->sclass == STATIC || p->sclass == EXTERN)
   582			q->x.name = stringf("%s%s%d", p->x.name, n >= 0 ? "+" : "", n);
   583		else
   584			q->x.name = stringd(q->x.offset);
   585	}
   586	static void export(p) Symbol p; {
   587		print(".global %s\n", p->x.name);
   588	}
   589	static void import(p) Symbol p; {}
   590	static void defsymbol(p) Symbol p; {
   591		if (p->scope >= LOCAL && p->sclass == STATIC)
   592			p->x.name = stringf("%d", genlabel(1));
   593		else
   594			assert(p->scope != CONSTANTS || isint(p->type) || isptr(p->type)),
   595			p->x.name = p->name;
   596		if (p->scope >= LABELS)
   597			p->x.name = stringf(p->generated ? "L%s" : "_%s",
   598				p->x.name);
   599	}
   600	static void segment(n) int n; {
   601		cseg = n;
   602		switch (n) {
   603		case CODE: print(".seg \"text\"\n"); break;
   604		case BSS:  print(".seg \"bss\"\n");  break;
   605		case DATA: print(".seg \"data\"\n"); break;
   606		case LIT:  print(".seg \"text\"\n"); break;
   607		}
   608	}
   609	static void space(n) int n; {
   610		if (cseg != BSS)
   611			print(".skip %d\n", n);
   612	}
   613	static void global(p) Symbol p; {
   614		print(".align %d\n", p->type->align);
   615		assert(p->u.seg);
   616		if (p->u.seg == BSS
   617		&& (p->sclass == STATIC || Aflag >= 2))
   618			print(".reserve %s,%d\n", p->x.name, p->type->size);
   619		else if (p->u.seg == BSS)
   620			print(".common %s,%d\n",  p->x.name, p->type->size);
   621		else
   622			print("%s:\n", p->x.name);
   623	}
   624	static void blkfetch(k, off, reg, tmp)
   625	int k, off, reg, tmp; {
   626		assert(k == 1 || k == 2 || k == 4);
   627		assert(salign >= k);
   628		if (k == 1)
   629			print("ldub [%%r%d+%d],%%r%d\n", reg, off, tmp);
   630		else if (k == 2)
   631			print("lduh [%%r%d+%d],%%r%d\n", reg, off, tmp);
   632		else
   633			print("ld [%%r%d+%d],%%r%d\n",   reg, off, tmp);
   634	}
   635	static void blkstore(k, off, reg, tmp)
   636	int k, off, reg, tmp; {
   637		assert(k == 1 || k == 2 || k == 4);
   638		assert(dalign >= k);
   639		if (k == 1)
   640			print("stb %%r%d,[%%r%d+%d]\n", tmp, reg, off);
   641		else if (k == 2)
   642			print("sth %%r%d,[%%r%d+%d]\n", tmp, reg, off);
   643		else
   644			print("st %%r%d,[%%r%d+%d]\n",  tmp, reg, off);
   645	}
   646	static void blkloop(dreg, doff, sreg, soff, size, tmps)
   647	int dreg, doff, sreg, soff, size, tmps[]; {
   648		if ((size&~7) < 4096) {
   649			print("add %%r%d,%d,%%r%d\n", sreg, size&~7, sreg);
   650			print("add %%r%d,%d,%%r%d\n", dreg, size&~7, tmps[2]);
   651		} else {
   652			print("set %d,%%r%d\n", size&~7, tmps[2]);
   653			print("add %%r%d,%%r%d,%%r%d\n", sreg, tmps[2], sreg);
   654			print("add %%r%d,%%r%d,%%r%d\n", dreg, tmps[2], tmps[2]);
   655		}
   656		blkcopy(tmps[2], doff, sreg, soff, size&7, tmps);
   657		print("1: dec 8,%%r%d\n", tmps[2]);
   658		blkcopy(tmps[2], doff, sreg, soff - 8, 8, tmps);
   659		print("cmp %%r%d,%%r%d; ", tmps[2], dreg);
   660		print("bgt 1b; ");
   661		print("dec 8,%%r%d\n", sreg);
   662	}
   663	static void defsymbol2(p) Symbol p; {
   664		if (p->scope >= LOCAL && p->sclass == STATIC)
   665			p->x.name = stringf(".%d", genlabel(1));
   666		else
   667			assert(p->scope != CONSTANTS || isint(p->type) || isptr(p->type)),
   668			p->x.name = p->name;
   669		if (p->scope >= LABELS)
   670			p->x.name = stringf(p->generated ? ".L%s" : "%s",
   671				p->x.name);
   672	}
       
   673	static void global2(p) Symbol p; {
   674		assert(p->u.seg);
   675		if (p->sclass != STATIC && !p->generated)
   676			print(".type %s,#%s\n", p->x.name,
   677				isfunc(p->type) ? "function" : "object");
   678		if (p->u.seg == BSS && p->sclass == STATIC)
   679			print(".local %s\n.common %s,%d,%d\n", p->x.name, p->x.name,
   680				p->type->size, p->type->align);
   681		else if (p->u.seg == BSS && Aflag >= 2)
   682			print(".align %d\n%s:.skip %d\n", p->type->align, p->x.name,
   683				p->type->size);
   684		else if (p->u.seg == BSS)
   685			print(".common %s,%d,%d\n", p->x.name, p->type->size, p->type->align);
   686		else
   687			print(".align %d\n%s:\n", p->type->align, p->x.name);
   688	}
       
   689	static void segment2(n) int n; {
   690		cseg = n;
   691		switch (n) {
   692		case CODE: print(".section \".text\"\n");   break;
   693		case BSS:  print(".section \".bss\"\n");    break;
   694		case DATA: print(".section \".data\"\n");   break;
   695		case LIT:  print(".section \".rodata\"\n"); break;
   696		}
   697	}
   698	#ifdef sparc
   699	#include <stab.h>
   700	static char *currentfile;       /* current file name */
   701	static int ntypes;
       
   702	static void stabblock ARGS((int, int, Symbol*));
   703	static void stabfend ARGS((Symbol, int));
   704	static void stabinit ARGS((char *, int, char *[]));
   705	static void stabline ARGS((Coordinate *));
   706	static void stabsym ARGS((Symbol));
   707	static void stabtype ARGS((Symbol));
       
   708	static void asgncode ARGS((Type, int));
   709	static void dbxout ARGS((Type));
   710	static int dbxtype ARGS((Type));
   711	static int emittype ARGS((Type, int, int));
       
   712	/* asgncode - assign type code to ty */
   713	static void asgncode(ty, lev) Type ty; int lev; {
   714		if (ty->x.marked || ty->x.typeno)
   715			return;
   716		ty->x.marked = 1;
   717		switch (ty->op) {
   718		case VOLATILE: case CONST: case VOLATILE+CONST:
   719			asgncode(ty->type, lev);
   720			ty->x.typeno = ty->type->x.typeno;
   721			break;
   722		case POINTER: case FUNCTION: case ARRAY:
   723			asgncode(ty->type, lev + 1);
   724			/* fall thru */
   725		case VOID: case CHAR: case SHORT: case INT: case UNSIGNED:
   726		case FLOAT: case DOUBLE:
   727			break;
   728		case STRUCT: case UNION: {
   729			Field p;
   730			for (p = fieldlist(ty); p; p = p->link)
   731				asgncode(p->type, lev + 1);
   732			/* fall thru */
   733		case ENUM:
   734			if (ty->x.typeno == 0)
   735				ty->x.typeno = ++ntypes;
   736			if (lev > 0 && (*ty->u.sym->name < '0' || *ty->u.sym->name > '9'))
   737				dbxout(ty);
   738			break;
   739			}
   740		default:
   741			assert(0);
   742		}
   743	}
       
   744	/* dbxout - output .stabs entry for type ty */
   745	static void dbxout(ty) Type ty; {
   746		ty = unqual(ty);
   747		if (!ty->x.printed) {
   748			int col = 0;
   749			print(".stabs \""), col += 8;
   750			if (ty->u.sym && !(isfunc(ty) || isarray(ty) || isptr(ty)))
   751				print("%s", ty->u.sym->name), col += strlen(ty->u.sym->name);
   752			print(":%c", isstruct(ty) || isenum(ty) ? 'T' : 't'), col += 2;
   753			emittype(ty, 0, col);
   754			print("\",%d,0,0,0\n", N_LSYM);
   755		}
   756	}
       
   757	/* dbxtype - emit a stabs entry for type ty, return type code */
   758	static int dbxtype(ty) Type ty; {
   759		asgncode(ty, 0);
   760		dbxout(ty);
   761		return ty->x.typeno;
   762	}
       
   763	/*
   764	 * emittype - emit ty's type number, emitting its definition if necessary.
   765	 * Returns the output column number after emission; col is the approximate
   766	 * output column before emission and is used to emit continuation lines for long
   767	 * struct, union, and enum types. Continuations are not emitted for other types,
   768	 * even if the definition is long. lev is the depth of calls to emittype.
   769	 */
   770	static int emittype(ty, lev, col) Type ty; int lev, col; {
   771		int tc = ty->x.typeno;
       
   772		if (isconst(ty) || isvolatile(ty)) {
   773			col = emittype(ty->type, lev, col);
   774			ty->x.typeno = ty->type->x.typeno;
   775			ty->x.printed = 1;
   776			return col;
   777		}
   778		if (tc == 0) {
   779			ty->x.typeno = tc = ++ntypes;
   780	/*              fprint(2,"`%t'=%d\n", ty, tc); */
   781		}
   782		print("%d", tc), col += 3;
   783		if (ty->x.printed)
   784			return col;
   785		ty->x.printed = 1;
   786		switch (ty->op) {
   787		case VOID:	/* void is defined as itself */
   788			print("=%d", tc), col += 1+3;
   789			break;
   790		case CHAR:	/* unsigned char is a subrange of int */
   791			if (ty == unsignedchar)
   792				print("=r1;0;255;"), col += 10;
   793			else	/* following pcc, char is a subrange of itself */
   794				print("=r%d;-128;127;", tc), col += 2+3+10;
   795			break;
   796		case SHORT:	/* short is a subrange of int */
   797			if (ty == unsignedshort)
   798				print("=r1;0;65535;"), col += 12;
   799			else	/* signed */
   800				print("=r1;-32768;32767;"), col += 17;
   801			break;
   802		case INT:	/* int is a subrange of itself */
   803			print("=r1;%d;%d;", INT_MIN, INT_MAX), col += 4+11+1+10+1;
   804			break;
   805		case UNSIGNED:	/* unsigned is a subrange of int */
   806			print("=r1;0;-1;"), col += 9;
   807			break;
   808		case FLOAT: case DOUBLE:	/* float, double get sizes instead of ranges */
   809			print("=r1;%d;0;", ty->size), col += 4+1+3;
   810			break;
   811		case POINTER:
   812			print("=*"), col += 2;
   813			col = emittype(ty->type, lev + 1, col);
   814			break;
   815		case FUNCTION:
   816			print("=f"), col += 2;
   817			col = emittype(ty->type, lev + 1, col);
   818			break;
   819		case ARRAY:	/* array includes subscript as an int range */
   820			if (ty->size && ty->type->size)
   821				print("=ar1;0;%d;", ty->size/ty->type->size - 1), col += 7+3+1;
   822			else
   823				print("=ar1;0;-1;"), col += 10;
   824			col = emittype(ty->type, lev + 1, col);
   825			break;
   826		case STRUCT: case UNION: {
   827			Field p;
   828			if (!ty->u.sym->defined) {
   829				print("=x%c%s:", ty->op == STRUCT ? 's' : 'u', ty->u.sym->name);
   830				col += 2+1+strlen(ty->u.sym->name)+1;
   831				break;
   832			}
   833			if (lev > 0 && (*ty->u.sym->name < '0' || *ty->u.sym->name > '9')) {
   834				ty->x.printed = 0;
   835				break;
   836			}
   837			print("=%c%d", ty->op == STRUCT ? 's' : 'u', ty->size), col += 1+1+3;
   838			for (p = fieldlist(ty); p; p = p->link) {
   839				if (p->name)
   840					print("%s:", p->name), col += strlen(p->name)+1;
   841				else
   842					print(":"), col += 1;
   843				col = emittype(p->type, lev + 1, col);
   844				if (p->lsb)
   845					print(",%d,%d;", 8*p->offset +
   846						(IR->little_endian ? fieldright(p) : fieldleft(p)),
   847						fieldsize(p));
   848				else
   849					print(",%d,%d;", 8*p->offset, 8*p->type->size);
   850				col += 1+3+1+3+1;	/* accounts for ,%d,%d; */
   851				if (col >= 80 && p->link) {
   852					print("\\\\\",%d,0,0,0\n.stabs \"", N_LSYM);
   853					col = 8;
   854				}
   855			}
   856			print(";"), col += 1;
   857			break;
   858			}
   859		case ENUM: {
   860			Symbol *p;
   861			if (lev > 0 && (*ty->u.sym->name < '0' || *ty->u.sym->name > '9')) {
   862				ty->x.printed = 0;
   863				break;
   864			}
   865			print("=e"), col += 2;
   866			for (p = ty->u.sym->u.idlist; *p; p++) {
   867				print("%s:%d,", (*p)->name, (*p)->u.value), col += strlen((*p)->name)+3;
   868				if (col >= 80 && p[1]) {
   869					print("\\\\\",%d,0,0,0\n.stabs \"", N_LSYM);
   870					col = 8;
   871				}
   872			}
   873			print(";"), col += 1;
   874			break;
   875			}
   876		default:
   877			assert(0);
   878		}
   879		return col;
   880	}
       
   881	/* stabblock - output a stab entry for '{' or '}' at level lev */
   882	static void stabblock(brace, lev, p) int brace, lev; Symbol *p; {
   883		if (brace == '{')
   884			while (*p)
   885				stabsym(*p++);
   886		print(".stabd 0x%x,0,%d\n", brace == '{' ? N_LBRAC : N_RBRAC, lev);
   887	}
       
   888	/* stabfend - end of function p */
   889	static void stabfend(p, line) Symbol p; int line; {}
       
   890	/* stabinit - initialize stab output */
   891	static void stabinit(file, argc, argv) int argc; char *file, *argv[]; {
   892		typedef void (*Closure) ARGS((Symbol, void *));
       
   893		if (file && *file) {
   894			(*IR->segment)(CODE);
   895			print("Ltext:.stabs \"%s\",0x%x,0,0,Ltext\n", file, N_SO);
   896			currentfile = file;
   897		}
   898		dbxtype(inttype);
   899		dbxtype(chartype);
   900		dbxtype(doubletype);
   901		dbxtype(floattype);
   902		dbxtype(longdouble);
   903		dbxtype(longtype);
   904		dbxtype(shorttype);
   905		dbxtype(signedchar);
   906		dbxtype(unsignedchar);
   907		dbxtype(unsignedlong);
   908		dbxtype(unsignedshort);
   909		dbxtype(unsignedtype);
   910		dbxtype(voidtype);
   911		foreach(types, GLOBAL, (Closure)stabtype, NULL);
   912	}
       
   913	/* stabline - emit stab entry for source coordinate *cp */
   914	static void stabline(cp) Coordinate *cp; {
   915		if (cp->file && cp->file != currentfile) {
   916			int lab = genlabel(1);
   917			print("L%d: .stabs \"%s\",0x%x,0,0,L%d\n", lab,
   918					cp->file, N_SOL, lab);
   919			currentfile = cp->file;
   920		}
   921		print(".stabd 0x%x,0,%d\n", N_SLINE, cp->y);
   922	}
       
   923	/* stabsym - output a stab entry for symbol p */
   924	static void stabsym(p) Symbol p; {
   925		int code, tc, sz = p->type->size;
       
   926		if (p->generated || p->computed)
   927			return;
   928		if (isfunc(p->type)) {
   929			print(".stabs \"%s:%c%d\",%d,0,0,%s\n", p->name,
   930				p->sclass == STATIC ? 'f' : 'F', dbxtype(freturn(p->type)),
   931				N_FUN, p->x.name);
   932			return;
   933		}
   934		if (!IR->wants_argb && p->scope == PARAM && p->structarg) {
   935			assert(isptr(p->type) && isstruct(p->type->type));
   936			tc = dbxtype(p->type->type);
   937			sz = p->type->type->size;
   938		} else
   939			tc = dbxtype(p->type);
   940		if (p->sclass == AUTO && p->scope == GLOBAL || p->sclass == EXTERN) {
   941			print(".stabs \"%s:G", p->name);
   942			code = N_GSYM;
   943		} else if (p->sclass == STATIC) {
   944			print(".stabs \"%s:%c%d\",%d,0,0,%s\n", p->name, p->scope == GLOBAL ? 'S' : 'V',
   945				tc, p->u.seg == BSS ? N_LCSYM : N_STSYM, p->x.name);
   946			return;
   947		} else if (p->sclass == REGISTER) {
   948			if (p->scope > PARAM) {
   949				int r = p->x.regnode->number;
   950				if (p->x.regnode->set == FREG)
   951					r += 32;	/* floating point */
   952				print(".stabs \"%s:r%d\",%d,0,", p->name, tc, N_RSYM);
   953				print("%d,%d\n", sz, r);
   954			}
   955			return;
   956		} else if (p->scope == PARAM) {
   957			print(".stabs \"%s:p", p->name);
   958			code = N_PSYM;
   959		} else if (p->scope >= LOCAL) {
   960			print(".stabs \"%s:", p->name);
   961			code = N_LSYM;
   962		} else
   963			assert(0);
   964		print("%d\",%d,0,0,%s\n", tc, code,
   965			p->scope >= PARAM && p->sclass != EXTERN ? p->x.name : "0");
   966	}
       
   967	/* stabtype - output a stab entry for type *p */
   968	static void stabtype(p) Symbol p; {
   969		if (p->type) {
   970			if (p->sclass == 0)
   971				dbxtype(p->type);
   972			else if (p->sclass == TYPEDEF)
   973				print(".stabs \"%s:t%d\",%d,0,0,0\n", p->name, dbxtype(p->type), N_LSYM);
   974		}
   975	}
   976	#else
   977	#define stabblock 0
   978	#define stabinit 0
   979	#define stabline 0
   980	#define stabsym 0
   981	#define stabtype 0
   982	#endif
   983	Interface sparcIR = {
   984		1, 1, 0,  /* char */
   985		2, 2, 0,  /* short */
   986		4, 4, 0,  /* int */
   987		4, 4, 1,  /* float */
   988		8, 8, 1,  /* double */
   989		4, 4, 0,  /* T * */
   990		0, 1, 0,  /* struct */
   991		0,  /* little_endian */
   992		1,  /* mulops_calls */
   993		1,  /* wants_callb */
   994		0,  /* wants_argb */
   995		1,  /* left_to_right */
   996		0,  /* wants_dag */
   997		address,
   998		blockbeg,
   999		blockend,
  1000		defaddress,
  1001		defconst,
  1002		defstring,
  1003		defsymbol,
  1004		emit,
  1005		export,
  1006		function,
  1007		gen,
  1008		global,
  1009		import,
  1010		local,
  1011		progbeg,
  1012		progend,
  1013		segment,
  1014		space,
  1015		stabblock, 0, 0, stabinit, stabline, stabsym, stabtype,
  1016		{
  1017			1,  /* max_unaligned_load */
  1018			blkfetch, blkstore, blkloop,
  1019			_label,
  1020			_rule,
  1021			_nts,
  1022			_kids,
  1023			_opname,
  1024			_arity,
  1025			_string,
  1026			_templates,
  1027			_isinstruction,
  1028			_ntname,
  1029			emit2,
  1030			doarg,
  1031			target,
  1032			clobber,
       
  1033		}
  1034	};
       
  1035	Interface solarisIR = {
  1036		1, 1, 0,  /* char */
  1037		2, 2, 0,  /* short */
  1038		4, 4, 0,  /* int */
  1039		4, 4, 1,  /* float */
  1040		8, 8, 1,  /* double */
  1041		4, 4, 0,  /* T * */
  1042		0, 1, 0,  /* struct */
  1043		0,	/* little_endian */
  1044		1,	/* mulops_calls */
  1045		1,	/* wants_callb */
  1046		0,	/* wants_argb */
  1047		1,	/* left_to_right */
  1048		0,	/* wants_dag */
  1049		address,
  1050		blockbeg,
  1051		blockend,
  1052		defaddress,
  1053		defconst,
  1054		defstring,
  1055		defsymbol2,
  1056		emit,
  1057		export,
  1058		function,
  1059		gen,
  1060		global2,
  1061		import,
  1062		local,
  1063		progbeg,
  1064		progend,
  1065		segment2,
  1066		space,
  1067		stabblock, 0, 0, stabinit, stabline, stabsym, stabtype,
  1068		{
  1069			1,	/* max_unaligned_load */
  1070			blkfetch, blkstore, blkloop,
  1071			_label,
  1072			_rule,
  1073			_nts,
  1074			_kids,
  1075			_opname,
  1076			_arity,
  1077			_string,
  1078			_templates,
  1079			_isinstruction,
  1080			_ntname,
  1081			emit2,
  1082			doarg,
  1083			target,
  1084			clobber,
       
  1085		}
  1086	};
