#include <stdio.h>
#ifndef NEW
#include "c.h"
#endif
#include "kdr.traverse.h"

#if TRAVERSE

				/* linearize trees, only root nodes .kdr*/
#define LINEARIZE 1
				/* linearize trees, all nodes .kdr*/
#define LINEARIZE_ALL 0

static void linearize_tree(Node p, FILE * of);

void traverse(Node p, char * file)
{
   Node q;
   FILE * outfile;
   static char opened = 0;
				/* open the file as append if we have already
				   written to it during this execution .kdr*/
   if (opened) outfile = fopen("trav.out","a");
   else {
      outfile = fopen("trav.out","w");
      assert(outfile);
				/* informational header .kdr*/
      fprintf(outfile,"Output generated by traverse in %s\n",file);
      opened = 1;
   }
   assert(outfile);
   for (q=(p); q; q = q->x.next) {
#if LINEARIZE && LINEARIZE_ALL
				/* dump tree for each node .kdr*/
	 linearize_tree(q, outfile);
	 fprintf(outfile,"\n");
#elif LINEARIZE
				/* the if makes it dump only roots .kdr*/
      if (q->x.listed) {
	 linearize_tree(q, outfile);
	 fprintf(outfile,"\n");
      }
#else
				/* use this if you just one the info on a 
				   node by node basis w/ no tree info .kdr*/
      fprintf(outfile,"%d.%d\n",q->op,q->x.inst);
#endif
   }
   fclose(outfile);
}

				/* recursive DFS to dump tree .kdr*/
void linearize_tree(Node p, FILE * of)
{
   if (p == NULL)      return;
				/* opname followed by node number, the node
				   number is only relevant w/ the symbolic
				   backend .kdr*/
   fprintf(of,"%s.%d",opname(p->op),p->x.inst);
   if (p->kids[0]) fprintf(of," (");
   linearize_tree(p->kids[0],of);
   if (p->kids[1]) fprintf(of,", ");
   linearize_tree(p->kids[1],of);
   if (p->kids[0]) fprintf(of,")");
}

#endif
