#include <mulsim_lib.h>

#define USE_TAS 1

#define ROWS 20
#define COLS 3

int X[ROWS][COLS], Y[COLS][ROWS], Z[ROWS][ROWS];
int next_row, row_lock, barrier1, barrier2;

void init_array(int *x, int rows, int cols, int value)
{
   int i, j;
   for (i = 0; i < rows * cols; i++, x++) *x = value;
}

void print_array(int *x, int rows, int cols)
{
   int i, j;
   for (i = 0; i < rows * cols; i++, x++) {
      print_int(*x);
      if (! ((i + 1) % cols)) print_str("\n");
   }
}

main()
{
   int r, c, row;
   next_row = barrier1 = barrier2 = 0;

   if (CPU_NUM == 0) {
      print_str("first, test UserArgc and UserArgv:\n");
      print_int(UserArgc); 
      print_int(UserArgv[0]);
      print_str("\nnow test the program itself:\n");
      init_array(&X[0][0], ROWS, COLS, 2);
      print_str("printing array X:\n");
      print_array(&X[0][0], ROWS, COLS);
   }
   if (CPU_NUM == 0) {
      init_array(&Y[0][0], COLS, ROWS, 2);
      print_str("printing array Y:\n");
      print_array(&Y[0][0], COLS, ROWS);
   }
   if (CPU_NUM == 0) init_array(&Z[0][0], ROWS, ROWS, 0);
				/* need a barrier to be sure that arrays have
				   been init'ed .kdr*/
   AINC(barrier1);
   while (barrier1 < SYS_SIZE) ;

   if (CPU_NUM == 0) print_str("about to multiply X * Y...\n");
   while ((row = AINC(next_row)) < ROWS) 
      for (r = 0; r < ROWS; r++) 
	for (c = 0; c < COLS; c++) Z[row][r] += X[row][c] * Y[c][r];

   AINC(barrier2);
   while (barrier2 != SYS_SIZE) ;

   if (CPU_NUM == 0) {
      print_str("printing array Z:\n");
      print_array(&Z[0][0], ROWS, ROWS);
   }
}
