/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the various definitions for the Tuple Manager.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */
#include    <stdio.h>
#include    <fcntl.h>
#include    <signal.h>
#include    <sys/types.h>
#include    <sys/file.h>
#include    <sys/socket.h>

#include    "linda_defs.h"
#include    "hsearch.h"

#ifndef INADDR_LOOPBACK
#define INADDR_LOOPBACK (u_long)0x7F000001
#endif

/*
 * Value of UdpPort. Note that the TcpPort is always UdpPort + 1 and BroadPort
 * is always UdpPort + 2
 */
#define LINDA_PORT                      4100

#define LINDA_RETRY            60
#define LINDA_NRETRY           3

#define LINDA_RESEND_TEMPLATE  60
#define LINDA_PURGE_TEMPLATE   80

#define TUPLE_SPACE_SIZE 	    2048
#define USERS_TABLE_SIZE            8
#define LOCAL_TEMPLATES_BUFFER_SIZE 16
#define OTHER_TEMPLATES_BUFFER_SIZE 64

extern int      MessageMatch();
extern int      EntryMatch();
extern int      TupleMatch();
extern int      TemplateMatch();
extern int      UserMatch();

static int      TemplateCallsSocket, TcpCallsSocket, UdpCallsSocket;
static int      LocalCallsSocket;
static int      OutSocket;
static int      UdpPort, TcpPort, BroadPort, Uid;
static struct sockaddr_in LocalAddress;
static struct sockaddr_in BroadcastAddress[10];
static int      NetworksNumber;
static struct timeval CallTimeOut = {LINDA_RETRY, 0};
static struct timeval PurgeInterval = {LINDA_PURGE_TEMPLATE, 0};
static struct timeval SendInterval = {LINDA_RESEND_TEMPLATE, 0};
static TABLE_OBJECT *Users;

#ifdef STATS
static struct stats
{
  int             sum, cnt;
}               Ostat, Lstat, Tstat, Zstat =
{
  0, 0
};
static int      LindaReadCalls = 0, LindaInCalls = 0, LindaOutCalls = 0, Reset = 0, LindaTemplateCalls = 0, Locals = 0, Tuples = 0, Others = 0;

#define statreport(st, val) { (st)->cnt++; (st)->sum += (val); }
#endif
