#ifndef lint
static char     sccsid[] = "@(#)system.c";
static char     Creator[] = "C 1991 G. Sxoinas csi.forth.gr \n";
static char     Mail[] = "sxoinas@ariadne.bitnet or sxoinas@csi.forth.gr";
#endif

/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the source code for an utility program that is used for accessing the system
 * functions of the Tuple Managers.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>

#include "linda_defs.h"


static int      broadsock;
static int      NetNumber = 0;
static struct timeval btimeout = {LINDA_RETRY_STATS, 0};
static struct timeval LocalCallTimeOut = {LINDA_RETRY_LOCAL, 0};
static struct sockaddr_in BroadcastAddress[10];
static Tmanager_Proc msg;

Print(from, len, st)
  struct sockaddr_in *from;
  int             len;
  STATS_MESSAGE  *st;
{
  printf("Tmanager(v%s) Statistics Report, Node %s\n", VERSION, st->node);
  if (msg == SYSTEM_STATS)
  {
#ifdef STATS
    printf("Out's: %d, In's: %d, Read's: %d, Template's: %d\n",
	   st->LindaOutCalls, st->LindaInCalls, st->LindaReadCalls, st->LindaTemplateCalls);
    printf("Template Resets: %d\n", st->Reset);
    printf("Mean Tuples Number: %lf\n", st->meanT);
    printf("Mean Locals Number: %lf\n", st->meanL);
    printf("Mean Others Number: %lf\n\n", st->meanO);
#else
    printf("No statistics available\n");
#endif
  }
  printf("%s\n\n", st->message);
  fflush(stdout);
}

void
Usage(progname)
  char           *progname;
{
  fprintf(stderr,
	  "Usage: %s [-n <network file>] [-r <rungroup>] <stats|reset|exit>\n", progname);
  exit(1);
}

main(argc, argv)
  int             argc;
  char          **argv;
{
  int             LocalSocket;
  struct sockaddr_un LocalAddress;
  register int    i, RunGroup = 0, port;
  char           *LocalServerSocketName, *netfile = NULL, *command = NULL, c;
  STATS_MESSAGE   st;
  SYSTEM_MESSAGE  sysmsg;
  Rpc_Stat        error;
  extern char    *optarg;
  extern int      optind, opterr;

  opterr = 0;
  while ((c = getopt(argc, argv, "r:n:")) != -1)
  {
    switch (c)
    {
    case 'r':
      RunGroup = atoi(optarg);
      break;
    case 'n':
      netfile = optarg;
      break;
    case '?':
      Usage(argv[0]);
      break;
    }
  }

  for (i = 0; i < argc; i++)
  {
    if (strcmp(argv[i], "stats", strlen(argv[i])) == 0)
    {
      command = argv[i];
      msg = SYSTEM_STATS;
    }
    else if (strcmp(argv[i], "exit", strlen(argv[i])) == 0)
    {
      command = argv[i];
      msg = SYSTEM_EXIT;
    }
    else if (strcmp(argv[i], "reset", strlen(argv[i])) == 0)
    {
      command = argv[i];
      msg = SYSTEM_RESET;
    }
  }

  broadsock = Rpc_UdpCreate(False, NULL);
  LocalSocket = Rpc_UnixSTCreate(False, NULL);
  strcpy(LocalAddress.sun_path, FindLocalName(SOCKNAME_LOCAL));
  LocalAddress.sun_family = AF_UNIX;
  port = GetPort(LocalSocket, &LocalAddress, &LocalCallTimeOut);
  LoadNetworks(netfile, BroadcastAddress, &NetNumber, port);
  sysmsg.uid = getuid();
  sysmsg.rungroup = RunGroup;
  if (command == NULL)
    Usage(argv[0]);
  for (i = 0; i < NetNumber; i++)
  {
    error = Rpc_Broadcast(broadsock, &BroadcastAddress[i], (Rpc_Proc) msg,
			  sizeof(SYSTEM_MESSAGE), &sysmsg,
			  sizeof(STATS_MESSAGE), &st,
			  LINDA_NRETRY_STATS, &btimeout, Print, FALSE);
    if (error != RPC_SUCCESS)
      fprintf(stderr, "system: %s\n", Rpc_ErrorMessage(error));
  }
}
