/*-
 * rpc.h --
 *	Declarations required by users of the rpc module.
 *
 * Copyright (c) 1987 by the Regents of the University of California
 * Copyright (c) 1987 by Adam de Boor
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 *	"$Header: rpc.h,v 1.5 88/07/06 17:27:33 adam Exp $ SPRITE (Berkeley)"
 */
#ifndef _RPC_H_
#define _RPC_H_

/*
 * Boolean arguments
 */
#define True	  1
#define False	  0

/*
 * js: MAX_DATA_SIZE is the absolute limit in the size of the data we can send
 * by using any part of the package and it has to do with its internal buffers
 */
#define MAX_DATA_SIZE   512*1024

/*
 * js: MAX_PACKET_SIZE is the limit in the size of the packets we can send by
 * using datagrams calls and is the size of the the send and receive buffers
 * for the sockets involved. Their default is 4k, at least for SunOs. In the
 * case of Udp the maximum allowable value is 8*1024
 */
#define MAX_PACKET_SIZE 4 * 1024

/*
 * js: MAX_MULTICAST_SIZE is the limit in the size of the packets that we be
 * send by using multicast(broadcast) operations and it is the maximum size of
 * the Ethernet packet
 */
#define MAX_MULTICAST_SIZE 1500

/* Ensure alignment of data send and received */
#ifndef RPC_ALIGN
#define RPC_ALIGN sizeof(int)	/* Alignment of data. Used in various parts of
				 * the system. It should be set to 8 if your
				 * machine cannot access doubles that are not
				 * double word aligned. Note that in Sun's Rpc
				 * package is also 4. Of course, some changes
				 * must also be made in the data arrays to
				 * ensure alignment. */
#endif

#ifndef Boolean
#define Boolean	  int
#endif				/* Boolean */

/*
 * Flags for Rpc_Watch
 */
#define RPC_READABLE	1
#define RPC_WRITABLE	2
#define RPC_EXCEPTABLE	4

typedef unsigned int Rpc_Proc;
typedef char   *Rpc_Opaque;

typedef char   *Rpc_Event;	/* Type returned by Rpc_EventCreate */
typedef char   *Rpc_Message;	/* Handle for replying to a call */

typedef enum
{
  RPC_SUCCESS,			/* Call succeeded, here's reply data */
  RPC_CANTSEND,			/* Couldn't send message, for some reason */
  RPC_TIMEDOUT,			/* Message timed out */
  RPC_TOOBIG,			/* Results (or message) too big */
  RPC_NOPROC,			/* No such procedure on remote machine */
  RPC_ACCESS,			/* Permission denied */
  RPC_BADARGS,			/* Arguments were improper */
  RPC_SYSTEMERR,		/* Undefined system error */
  RPC_DISCONNECT,		/* Connection broken by server */
}               Rpc_Stat;

/*
 * Swapping definitions
 */
#define Rpc_SwapNull	((void (*)())0)	/* Constant for no swapping */
extern void     Rpc_SwapShort();/* Swap a short integer (two bytes) */
extern void     Rpc_SwapLong();	/* Swap a long integer (four bytes) */

/*
 * Other definitions
 */
extern void     Rpc_ServerCreate();	/* Create a service on a socket */
extern void     Rpc_ServerDelete();	/* Delete a service on a socket */
extern char    *Rpc_EventCreate();	/* Create a timer event */
extern void     Rpc_EventDelete();	/* Delete a timer event */
extern void     Rpc_EventReset();	/* Reset the time of an event */
extern void     Rpc_Watch();	/* Watch a stream */
extern void     Rpc_Ignore();	/* Ignore a stream */
extern void     Rpc_Error();	/* Return an error to an RPC call */
extern Rpc_Stat Rpc_Return();	/* Return a reply to an RPC call */
extern Rpc_Stat Rpc_Call();	/* Call a remote procedure */
extern struct in_addr RpcGetNetwork();	/* Get a network for broadcasting */
extern Rpc_Stat Rpc_Broadcast();/* Broadcast a call to a remote procedure */
extern void     Rpc_Wait();	/* Wait for something to happen */
extern void     Rpc_Run();	/* Wait forever for something to happen */
extern int      Rpc_TcpCreate();/* Create a TCP socket with a name */
extern int      Rpc_UdpCreate();/* Create a UDP socket with a name */
extern void     Rpc_Debug();	/* Turn on debugging printouts */
extern int      Rpc_MessageSocket();	/* Return the socket for a message */
extern char    *Rpc_ErrorMessage();	/* Return a string describing an error
					 * status */
extern void     Rpc_Reset();	/* Reset the module, deleting all services,
				 * timer events and watched streams */
extern Rpc_Message Rpc_GetMsg();/* js:Get a copy of the msg on dynamic store */
/*
 * js: More definitions
 */

#include <sys/types.h>
#include <netinet/in.h>

struct sockaddr_x
{
  short           sa_family;
  short           sa_port;
  int             sa_data[26];
  char            pad[2];
};
#endif				/* _RPC_H_ */
