/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the various definitions used by all the portions of the system.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */

#include "version.h"

#include <sys/time.h>

#include "rpc.h"		/* include header file of the rpc routines */

#define SOCKNAME_LOCAL "/tmp/.TMANAGER"	/* the filename on which the tmanager
					 * waits for requests */

typedef enum
{
  LINDA_OUT,
  LINDA_IN,
  LINDA_READ,
  LINDA_NETOUT,
  LINDA_TEMPLATE,
  LINDA_INP,
  LINDA_READP,
  SYSTEM_EXIT,
  SYSTEM_STATS,
  SYSTEM_RESET,
  SYSTEM_GETPORT
}               Tmanager_Proc;	/* The id's of the remote procedures
				 * implemented by the Tuple Manager */

/* Timeout(sec's) and number of retries of a call to the local Tuple Manager */
#define LINDA_RETRY_LOCAL      120
#define LINDA_NRETRY_LOCAL     2

/*
 * Timeout(sec's) and number of retries of a broadcast call for system commands
 */
#define LINDA_RETRY_STATS      10
#define LINDA_NRETRY_STATS     1

#ifndef TRUE
#define FALSE  0
#define TRUE   (!FALSE)
#endif

/*
 * Next follow some definition of flags used in the system to characterize the
 * field types. In order to add a type in the system you must define a new mask
 * and add the needed code in the files 'linda_util.c', 'hmatch.c' and
 * 'linda_calls.c'.
 */

/* Actual fields */
#define NONE		0
#define CHAR		0x01
#define SHORT		0x02
#define INT  		0x03
#define FLOAT		0x04
#define DOUBLE		0x05
#define ARRAY_OF_CHAR   (CHAR | 0x10)
#define CHAR_STRING     (CHAR | 0x30)
#define ARRAY_OF_SHORT  (SHORT | 0x10)
#define ARRAY_OF_INT    (INT | 0x10)
#define ARRAY_OF_FLOAT  (FLOAT | 0x10)
#define ARRAY_OF_DOUBLE	(DOUBLE | 0x10)

/* Formal fields */
#define CHAR_Q		  (CHAR | 0x40)
#define SHORT_Q		  (SHORT | 0x40)
#define INT_Q 		  (INT | 0x40)
#define FLOAT_Q	 	  (FLOAT | 0x40)
#define DOUBLE_Q	  (DOUBLE | 0x40)
#define ARRAY_OF_CHAR_Q	  (ARRAY_OF_CHAR | 0x40)
#define ARRAY_OF_SHORT_Q  (ARRAY_OF_SHORT | 0x40)
#define ARRAY_OF_INT_Q 	  (ARRAY_OF_INT | 0x40)
#define ARRAY_OF_FLOAT_Q  (ARRAY_OF_FLOAT | 0x40)
#define ARRAY_OF_DOUBLE_Q (ARRAY_OF_DOUBLE | 0x40)
#define CHAR_STRING_Q     (CHAR_STRING | 0x40)

#define isformal(x)	 ((x) & 0x00000040)
#define actual(x)        ((x) & 0x000000bf)
#define isarray(x)	 ((x) & 0x00000010)
#define adjust(x)	 { x += (x % RPC_ALIGN == 0 ? 0 : RPC_ALIGN - (x % RPC_ALIGN)); }

typedef struct
{
  int             id;		/* Type of field */
  int             data[2];	/* Data area used to store the data for the
				 * field */
}               FIELD;

/* More definitions */

/*
 * Struct to hold information for eval's. This information comes from the
 * '.nodefile'
 */
typedef struct
{
  char            name[128];
  float           arch, load;
  char            Naliases[10][128];
}               NODEINFO;

/* Definition of tmanager-clients message formats */

typedef struct
{
  int             uid, rungroup, keybytes, databytes;
}               TUPLE_HEADER;

typedef struct
{
  int             pid, uid, rungroup, keybytes, databytes;
}               TEMPLATE_HEADER;

#define MAXTUPLEN ((MAX_DATA_SIZE - sizeof(TUPLE_HEADER)) / RPC_ALIGN + 1)
#define MAXTEMLEN ((MAX_MULTICAST_SIZE - sizeof(TEMPLATE_HEADER))/ RPC_ALIGN)
#define MAXRESLEN ((MAX_DATA_SIZE) / RPC_ALIGN + 1)

typedef struct
{
  TUPLE_HEADER    header;
  int             message_data[MAXTUPLEN];
}               TUPLE_MESSAGE;

typedef struct
{
  TEMPLATE_HEADER header;
  int             message_data[MAXTEMLEN];
}               TEMPLATE_MESSAGE;

typedef struct
{
  int             message_data[MAXRESLEN];
}               RESPONSE_MESSAGE;

typedef struct
{
  double          meanT, meanL, meanO;
  int             LindaOutCalls, LindaInCalls, LindaReadCalls, LindaTemplateCalls, Reset, pad;
  char            node[128];
  char            message[256];
}               STATS_MESSAGE;

typedef struct
{
  int             uid, rungroup;
}               SYSTEM_MESSAGE;
