
/*		   	L I N D A  W O R K E R	
 * 
 *
 *	Each worker tries to get a row index of a row of the product
 * matrix to be computed from the tuple space. Once successful, it 
 * updates the row index and places it back in the tuple space for
 * some other worker waiting to pick it.  If the index is equal to the 
 * dimension, the worker updates it to -1 denoting termination, otherwise 
 * if positive, it increments it by 1. In either case, the worker proceeds
 * to compute the row of the product matrix . If the index is negative, it
 * indicates that there are no more rows to be computed.  In such a 
 * case the worker returns the tuple back to the tuple space and quits.
 */ 
 	
/*
 * Initially found in a distribution of C-Linda Simulator for Sun-4, by SCA,
 * Inc.
 * 
 * Modified for POSYBL by Giannis Schoinas.
 */

#define TRUE 1

main()
{
  long	col_index, dim, dot, index, next_index, row_index;
  long	*cp, col[256], result[256], row[256], *rp, *ptr;

  /* read the dimension N of the matrices */

  rd(lstring("dim"), qlint(&dim));

  while(TRUE) {

    /* get index of row of product matrix to compute */

    in(lstring("row_index"), qlint(&row_index));

    /* if no more rows remain to be computed return tuple back to tuple
       space and return
     */

    if (row_index < 0) {
      out(lstring("row_index"), lint(-1));
       return(1);
    }

    /* increment the row index */

    next_index = row_index + 1;

    /* Place the updated row index tuple if any row remains to be
       computed 
    */
    if (next_index < dim)
      out(lstring("row_index"), lint(next_index));

    else
      
      /* else put termination tuple */

      out(lstring("row_index"), lint(-1));

    /* read the the row of the first matrix */
    
    rd(lstring("row"), lint(row_index), qlnint(&ptr,&dim));
    copyints(row, ptr, dim);

    /* read each column of the second matrix, one at a time, compute 
       the row-column dot product, and store it in the corresponding
       position in the result vector ( product matrix row).

   */

    for (col_index = 0 ; col_index < dim; ++col_index) {

      rd(lstring("col"), lint(col_index), qlnint(&ptr,&dim));
      copyints(col, ptr, dim);

      /* initialise the variables for the dot product */

      dot = 0;
      rp = row;
      cp = col;

      /* compute the dot product */

      for (index = 0; index < dim; ++index, ++rp, ++cp) {
	dot += *rp * *cp;
      }
      result[col_index] = dot;
    }
   
   
    /* after all the columns have been read in, store the result
       vector in the tuple space.
    */
    out(lstring("prod"), lint(row_index), lnint(result,dim));
  }
}
