#ifndef lint
static char     sccsid[] = "@(#)times.c";
static char     Creator[] = "C 1991 G. Sxoinas csi.forth.gr \n";
static char     Mail[] = "sxoinas@ariadne.bitnet or sxoinas@csi.forth.gr";
#endif

/*
 * This file is part of the POSYBL (PrOgramming SYstem for distriButed
 * appLications, a free Linda implementation for Unix Networks) and contains
 * the source code for some timing routines.
 * 
 * There are no restrictions on this code; however, if you make any changes, I
 * request that you document them so that I do not get credit or blame for your
 * modifications.
 * 
 * Written by Ioannis Schoinas (sxoinas@csd.uch.gr or sxoinas@csi.forth.gr),
 * Computer Science Department, University of Crete, Heraclion, Crete, Greece.
 * 
 * Note: Linda is a trademark of SCA, Inc.
 * 
 */
#include <stdio.h>
#include <sys/time.h>

static struct info
{
  struct timeval  time;
  char            str[128];
};

static struct info info[32];
static int      cnt;

start_timer()
{
  gettimeofday(&info[0].time, NULL);
  sprintf(info[0].str, "Timer started");
  cnt = 1;
}

timer_split(s)
  char           *s;
{
  strncpy(info[cnt].str, s, 127);
  gettimeofday(&info[cnt].time, NULL);
  cnt++;
}

print_times()
{
  register int    i, t11, t22, t12, t21;
  char            name[32];

  gethostname(name, 32);
  fprintf(stderr, "Node:%s Pid:%d\n", name, getpid());
  fprintf(stderr, "Split\tSince start\tSince last\t Info\n");
  for (i = 0; i < cnt; i++)
  {
    t11 = info[i].time.tv_sec - info[0].time.tv_sec;
    t12 = info[i].time.tv_usec - info[0].time.tv_usec;
    if (t12 < 0)
    {
      t11--;
      t12 = 1000000 + t12;
    }
    if (i == 0)
      t21 = t22 = 0;
    else
    {
      t21 = info[i].time.tv_sec - info[i - 1].time.tv_sec;
      t22 = info[i].time.tv_usec - info[i - 1].time.tv_usec;
      if (t22 < 0)
      {
	t21--;
	t22 = 1000000 + t22;
      }
    }
    fprintf(stderr, "%2d\t%d.%06d\t%d.%06d\t %s\n", i, t11, t12, t21, t22, info[i].str);
  }
  fflush(stderr);
}
