.TH NODEFILE 1L "1 March 1991"
.SH NAME
NodeFile \- Node specific information and variables 
.SH SYNOPSIS
.B ./.nodefile 
.B ~/.nodefile 
.SH DESCRIPTION
The
.I nodefile
is a file that contains in each line the name of the node
and a float value(preference) that represents an estimation of the processing
power of the node, that is, the bigger this value is, the more powerful
the node is. This estimation is just a relative power measure
of the nodes listed in a 
.I nodefile
and should need not be very accurate. Its meaning is that
the eval's will be done first in the nodes that have this value
higher than the others. If you compile the system with DYNAMIC flag
some load information will be gathered and used with the preference
value to find the most preferred node. Unfortunately, this is done
by using the get_rusage() rpc call that is supported only in Suns.
If you plan to use the system in an environment with other
machines, you should not define this compilation flag. 
An entry can be commented out, if you precede
the name of the node with an exclamation mark (!). 
After a node entry the user can specify up to 10 (#0 - #9) 
node dependent variables and their content.
These variables can be used with the arguments to the eval() 
calls as well as the arguments to the startup command.
When such a variable is found in these places it is replaced with its content. 
A good convevtion is to use the #0 variable for the path of the
Tuple Manager and the #1 variable for the architecture of the node.
.SH EXAMPLES
.IP
example% cat sample_nodefile
.br
alkistis 4
.br
#0 ~sxoinas/try/bin/tmanager.sun4
.br
#1 ~sxoinas/try/demos/xmandel/slave.sun4
.br
antigone 2 
.br
#0 ~sxoinas/try/bin/tmanager.sun3
.br
#1 ~sxoinas/try/demos/xmandel/slave.sun3
.br
!ekavi 0.5 (commented)
.br
!#0 ~sxoinas/try/bin/tmanager.sun3 (commented)
.br
!#1 ~sxoinas/try/demos/xmandel/slave.sun3 (commented)

.IP
example% startup -f sample_nodefile #0
.PP
In this example #0 will be replaced with ~sxoinas/try/bin/tmanager.sun4 
for node alkistis and with ~sxoinas/try/bin/tmanager.sun3 for node antigone.

.IP
example% cat main.c
.br
 ...
.br
	for (i=0;i<nworkers;i++)
.br
           eval_l("#1",NULL);
.br
 ...
.PP
In this example #1 will be replaced with ~sxoinas/try/demos/xmandel/slave.sun4
for node alkistis and with ~sxoinas/try/demos/xmandel/slave.sun3 for node
antigone.
.SH FILES
 ~/.nodefile,
 ./.nodefile
.SH SEE ALSO
.BR startup(1L),
.BR system(1L),
.BR tmanager(1L),
.BR posybl(1L)
.SH BUGS (Some call them features)
Some load information should be maintained by exchanging messages
between the Tuple Managers, instead of using the get_rusage()
rpc calls. But when I implemented this code it was much more
easier to use this call and I wasn't really interested in such a feature. 
I should have changed it by now to a
scheme according to which, load information messages would be exchanged between 
the Tuple Managers by broadcasts every few minutes and before the eval 
is executed a call to the local Tuple Manager could be made to get the node 
with the highest (preference / load) value. The only problem with this
scheme is that we should send to the Tuple Manager the list of nodes
that we are interested in and he should choose the best among them.
If I find time, I will try it. 
.SH AUTHOR
Ioannis Schoinas, sxoinas@csd.uch.gr
.SH ACKNOWLEDGEMENTS
I would like to thank everybody that helped me in writing this program
and especially I. Kavaklis for offering his ideas, some pieces of code,
demo programs, and for being the first subject to test this system.

