/*			L I N D A  W O R K E R 			*/

/*
 * Initially found in a distribution of C-Linda Simulator for Sun-4, by SCA,
 * Inc.
 * 
 * Modified for NetLinda Prototype System by Giannis Schoinas.
 */

#define NUM_INIT_PRIME  15
#define MAX_GRAIN 100000
#define MAX_LIMIT 100000

long            primes[MAX_LIMIT / 10 + 1] = {2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43,
47};
long            p2[MAX_LIMIT / 10 + 1] = {4, 9, 25, 49, 121, 169, 289, 361, 529, 841, 961, 1369, 1681, 1849, 2209};

main()

{
 int             count, eot, i, limit, num, num_primes, ok, start;
 long            my_primes[MAX_GRAIN];
 int 		 LIMIT, GRAIN;

 printf("worker started\n");

 in(lstring("init"), qlint(&LIMIT), qlint(&GRAIN));
 num_primes = NUM_INIT_PRIME;

 eot = 0;

 while (1)
 {

  /* acquire lower limit of a chunk to be test for primality */

  in(lstring("num"), qlint(&num));

  /* if negative, then no more primes to be found */

  if (num == -1)
  {

   /*
      replace the chunk specifier tuple with negative lower limit indicating
      completion of the job
   */
   out(lstring("num"), lint(-1));

   /* quit */

   out(lstring("done"));
   return;
  }

  /* else */

  /*
     increment the chunk lower limit and place it back in the tuple space for
     another worker to pick up
  */
  limit = num + GRAIN;
  out(lstring("num"), lint((limit > LIMIT) ? -1 : limit));

  /* clip the upper limit of the chunk if greater than LIMIT */

  if (limit > LIMIT)
   limit = LIMIT;

  start = num;

  /* for every odd number in the chunk */

  for (count = 0; num < limit; num += 2)
  {

   /*
      while the flag is reset and the square of the last prime read from the
      tuple space is less than  num i.e. while the last prime read is less than
      the square root of num
   */
   while (!eot && num > p2[num_primes - 1])
   {

    /* read the next unread prime and its square from the tuple space */

    rd(lstring("prime"), lint(num_primes), qlint(&primes[num_primes]), 
       qlint(&p2[num_primes]));

    /*
       if the square of the prime read is negative, set eot, indicating that no
       more primes need to be read from the tuple space
    */
    if (p2[num_primes] < 0)
     eot = 1;

    /* else increment the count of the primes read */

    else
     ++num_primes;
   }

   /*
      check the number for primality i.e. check whether any prime number less
      than the sqaure root of the number is a factor of the number. If none,
      then the number is prime.
   */
   for (i = 1, ok = 1; i < num_primes; ++i)
   {

    /* if zero remainder */

    if (!(num % primes[i]))
    {

     /* num has a prime factor, reset ok and break */

     ok = 0;
     break;
    }

    /*
       if none of the primes, less than the square root, factorise the number,
       then break.  The flag ok remains set.  The cond- ition "square root of
       number < prime number" has been modif- ied to "number < square of the
       prime number"
    */
    if (num < p2[i])
     break;
   }

   /*
      if ok is set, then the number is prime.  Add it to the set and increment
      the set count.
   */
   if (ok)
   {
    my_primes[count] = num;
    ++count;
   }
  }

  /* Send the control process any primes found. */

  out(lstring("result"), lint(start), lnint(my_primes, count));
 }
}
