#include <stdio.h>

/* 
 * global variables
 */

static int mwidth;
static double upper_x, incrx;
static int max_iter, wwidth;
static int depth;


/*
 * worker operation which calculates the number of iterations
 * required to make |Zn| >= 2
 */
static void calc_row(double* in, unsigned char* out) {
	int ix, i;
	double x, wx, wy, oldwx;
	double y;
	unsigned char* dp;

	y = *(double*) in;
	dp = (unsigned char*) out;
	x = upper_x;
	if (depth == 1)
		bzero(dp, mwidth);
	for (ix = 0; ix < wwidth; ++ix, x += incrx) {
		wx = x; wy = y;
		for (i = 0; i < max_iter; ++i) {
			oldwx = wx;
			wx = wx * wx - wy * wy + x;
			wy = 2 * oldwx * wy + y;
			if ((wx * wx + wy * wy) > 4) break;
		}
		if (depth > 1)
			dp[ix] = i;
		else
			if (i == max_iter) dp[ix/8] |= (1 << (7 - (ix % 8)));
	}
}


/*
 * definitions of context operation
 */

void set_x(double* arg) {
	upper_x = *(double*) arg;
}

void set_incrx(double* arg) {
	incrx = *(double*) arg;
}

void set_iter(int* arg) {
	max_iter = *(int*) arg;
}

void set_depth(int* arg) {
	depth = *(int*) arg;
}

void set_wwidth(int* arg) {
	wwidth = *(int*) arg;
}

void set_mwidth(int* arg) {
	mwidth = *(int*) arg;
}


/*
 * declarations of global descriptors 
 */


main( int argc, char** argv) {
	char *out1;
	int iy;
	double y;

	in(lstring("depth"),qlint(&depth));
	printf("depth taken = %d\n",depth);
	fflush(stdout);
	while(1) {
	in(lstring("context"),qldouble(&upper_x),qldouble(&incrx),qlint(&max_iter),qlint(&wwidth),qlint(&mwidth));
	if(max_iter <0) exit(0);
	if(out1 != NULL) free (out1);
	out1 = (char *)malloc(wwidth);
	
	while (iy >= 0) {
	in(lstring("job"),qldouble(&y),qlint(&iy));
	if(iy < 0) continue;
	calc_row((double *)&y,(unsigned char *)out1);
	out(lstring("result"),lnchar(out1,mwidth),lint(iy));
	}
	iy = 10;
	}
	/*slave_loop(argc, argv);*/
}
