
#define NAME_SZ 50

// class definitions

// one simulation element, e.g. one job for a machine to process
class ESElt  {
   public:
      // class variables and functions
      static ESElt *ESSchedListHd;  // head of event list
      static ESElt *ESCurrEvnt;  // currently-processed event

      static void ESGetNext();  // remove head of event list, and make
                                // it the currently-processed event
      static ESElt *ESCancel(int);  // remove event from the event list
      static int ESEvntMatch(char *);  // checks for specified event type
      static void ESEvntHandler();  // user-defined, event-type-dependent; 
                                    // does the processing of the current 
                                    // event
      // instance variables and functions
      char ESName[NAME_SZ];  // event name, for debugging purposes
      float ESEvntTime;  // event occurrence time
      int ESEltNumber;  // event ID number
      ESElt *ESNext;  // pointer to next event in event list
      ESElt();  // constructor function
      void ESInsertInSchedList();  // insert the element pointed to by
                                   // ESSim::ESCurrEvnt to event list
      // the following functions are debugging aids; note that you may
      // wish to extend them to customize your debugging in some
      // cases; see for example ESPrintElt() in the example MM1.cpp
      static void ESPrintSchedList();  
      void ESPrintElt();  
};

// one simulated facility, e.g. a machine; allows for multiple servers 
// with one common queue 
class ESFacil  {
   public:
      char ESName[NAME_SZ];  // name of facility, e.g. "machine"
      int ESNServers;  // number of servers (typically 1)
      int ESNBusy;  // number of currently busy servers
      int ESNQ;  // number of jobs in queue
      ESElt *ESFclQHd,*ESFclQTl;  // ptrs to queue head and tail 

      // constructor function, with parameters name and number of servers 
      ESFacil(const char FacilName[], const int NS);  

      void ESAppendToFclQ();  // add element pointed to by ESElt::ESCurrEvnt
                              // to end of facility queue
      void ESStartServe(ESElt *, float);  // start service for the element
                                          // pointed to by the first
                                          // argument
      int ESDoneServe(float);  // does bookkeeping associated with finishing
                               // one job and starting the next, if any
      
      // for debugging; again, may wish to override
      void ESPrintFclInfo();  
};

// this class contains data and methods related to the general operation
// of ESim
class ESSim  {
   public:
      // class variables and functions
      static float ESSimTime;  // current simulated time
      static float ESMaxSimTime;  // amount of simulated time to be run 
      static int ESDebug;  // 1 for debugging, else 0
      static int ESNextNew;  // ID number to be assigned to the next 
                             // ESElt created

      static void ESInit(char **);  // ESim inits
      static void ESMainLoop(char **);  // main simulation loop
      static float ESRnd();  // U(0,1) random variable generator
      static float ESExpon(float);  // exponential random variable generator
};


