




/*  

*************************************************************
*                                                           *
*                    axy_worker.c                           *
*                                                           *
*                INTRODUCTORY PVM EXAMPLE                   *
*                                                           *
*                                                           *
*                                                           *
*************************************************************

*/


/* does the work managed by axy_worker.c */


#include "/root/PVM3/include/pvm3.h"
#include <stdio.h>


#define MAXROW 100
#define MAXWORKERS 100


/* message types */
#define REQUEST_ROW 0
#define REPORT_YR 1
#define PROVIDE_ROW 2
#define PROVIDE_NROWS_AND_X 3
#define ALL_DONE 4


int AR[MAXROW],  /* Rth row of A */
    X[MAXROW],  /* the multiplicand */
    YR,  /* the row product */
    NRows,  /* number of rows in A */
    ParentTID,  /* TID for the manager */
    MyTID,R;


Mult()

{  int I;

   YR = 0;
   for (I = 0; I < NRows; I++)  YR += AR[I]*X[I];
}


main()

{  /* get PVM operations started */
   MyTID = pvm_mytid();  /* enroll in PVM */

   /* who is the manager? */
   ParentTID = pvm_parent();

   /* get NRows and X */
   pvm_recv(ParentTID,PROVIDE_NROWS_AND_X);
   pvm_upkint(&NRows,1,1);
   pvm_upkint(X,NRows,1);

   while (1)  {
      /* done? */
      if (pvm_probe(ParentTID,ALL_DONE) > 0)  {
         pvm_exit();
	 exit();
      }
      /* request row */
      pvm_initsend(PvmDataDefault);
      pvm_send(ParentTID,REQUEST_ROW);
      /* receive response */
      pvm_recv(ParentTID,PROVIDE_ROW);
      pvm_upkint(&R,1,1);
      pvm_upkint(AR,NRows,1); 
      /* do the multiplication */
      Mult();
      /* send the result back */
      pvm_initsend(PvmDataDefault);
      pvm_pkint(&R,1,1);
      pvm_pkint(&YR,1,1);
      pvm_send(ParentTID,REPORT_YR);
   }
}

