\name{ratioest}
\alias{ratioest}

\title{
Ratio comparison of regression functions, two groups.
}

\description{

Group comparison via comparison of regression functions.
Nonparametrically estimates the regression function of Y on X1 and X2,
and plots the ratio of the two functions at each data point, enabling
exploration of the interaction of the groups and X1, X2 and Y.  The
estimation is optionally done via parallel computation.

}

\usage{
ratioest(xyz, yvar, xvars, grpvar, numergrp, k = NULL, coding = "dot size", 
    samp = 0, xlb = NULL, ylb = NULL, cls = NULL, nchunks = length(cls)) 
}

\arguments{
   \item{xyz}{The data, in data frame or matrix form.}
   \item{yvar}{Column of \code{xyz} to be serve as the Y variable.}
   \item{xvars}{Columns of \code{xyz} to be serve as X1 and X2..}
   \item{grpvar}{Column for the grouping variable; vector or factor.
      Must define exactly 2 groups.}
   \item{numergrp}{Group value to be used in the numerator of the ratios.}
   \item{k}{Number of nearest neighbors.}
   \item{coding}{Ratio size coding, "dot size" or "color".}
   \item{xlb}{Label for horizontal axis.}
   \item{ylb}{Label for vertical axis.}
   \item{cls}{Cluster to use (see the \code{parallel} package) for
      parallel computation.}
   \item{nchunks}{Number of chunks to break the computation into.}
}


\details{The regression functions of Y on X1 and X2 will be computed at
each data point, for each group.  If \code{cls} is non-null, the
computation will be done in parallel.  Then the ratio of the two
functions will be plotted at each data point.  If overplotting is a
concern, one can optionally plot just \code{samp} points, though the
full data will still be used in computing the regression functions.

Further explanation of \code{numergrp}:  Say the grouping variable
takes on two values, "foreign" and "domestic", and one wants the former
value to be represented in the numerators of the ratios.  Then one sets
\code{numergrp} to "foreign".
}

\value{A \code{ggplot2} object, which when printed causes the graph to
be displayed.  
}

\author{
Norm Matloff <matloff@cs.ucdavis.edu>
}

% \keyword{
% }

% \seealso{
% }

\examples{
c2 <- shmcls(2)

testratsim <- function(n,sig,cls) {
   n2 <- 2 * n
   x1 <- matrix(rnorm(n2,mean=5,sd=sig),ncol=2)
   x1 <- cbind(x1,1)
   x1 <- cbind(x1,x1[,1:2] \%*\% c(2,3) + rnorm(n,mean=0,sd=0.2*sig))
   x0 <- matrix(rnorm(n2,mean=5,sd=sig),ncol=2)
   x0 <- cbind(x0,0)
   x0 <- cbind(x0,x0[,1:2] \%*\% c(1,0) + rnorm(n,mean=0,sd=0.2*sig))
   x <- rbind(x1,x0)
   ratioest(x,4,1:2,3,cls=c2)
}

testratsim(1000,1,c2)
# bigger dots should be toward lower-right
}


